/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.collection.RawIterator;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.ProcedureSignature;

public class ProcedureRegistry {
    private final Map<ProcedureSignature.ProcedureName, CallableProcedure> procedures = new HashMap<ProcedureSignature.ProcedureName, CallableProcedure>();

    public synchronized void register(CallableProcedure proc) throws ProcedureException {
        ProcedureSignature signature = proc.signature();
        ProcedureSignature.ProcedureName name = signature.name();
        this.validateSignature(signature, signature.inputSignature(), "input");
        this.validateSignature(signature, signature.outputSignature(), "output");
        if (this.procedures.putIfAbsent(name, proc) != null) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register procedure, because the name `%s` is already in use.", name);
        }
    }

    private void validateSignature(ProcedureSignature signature, List<ProcedureSignature.FieldSignature> fields, String fieldType) throws ProcedureException {
        HashSet<String> names = new HashSet<String>();
        for (ProcedureSignature.FieldSignature field : fields) {
            if (names.add(field.name())) continue;
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Procedure `%s` cannot be registered, because it contains a duplicated " + fieldType + " field, '%s'. You need to rename or remove one of the duplicate fields.", signature.toString(), field.name());
        }
    }

    public ProcedureSignature get(ProcedureSignature.ProcedureName name) throws ProcedureException {
        CallableProcedure proc = this.procedures.get(name);
        if (proc == null) {
            throw this.noSuchProcedure(name);
        }
        return proc.signature();
    }

    public RawIterator<Object[], ProcedureException> call(CallableProcedure.Context ctx, ProcedureSignature.ProcedureName name, Object[] input) throws ProcedureException {
        CallableProcedure proc = this.procedures.get(name);
        if (proc == null) {
            throw this.noSuchProcedure(name);
        }
        return proc.apply(ctx, input);
    }

    private ProcedureException noSuchProcedure(ProcedureSignature.ProcedureName name) {
        return new ProcedureException((Status)Status.Procedure.ProcedureNotFound, "There is no procedure with the name `%s` registered for this database instance. Please ensure you've spelled the procedure name correctly and that the procedure is properly deployed.", name);
    }

    public Set<ProcedureSignature> getAll() {
        return this.procedures.values().stream().map(CallableProcedure::signature).collect(Collectors.toSet());
    }
}

