/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.constraints;

import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.store.record.PropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.UniquePropertyConstraintRule;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class StandardConstraintSemantics
implements ConstraintSemantics {
    public static final String ERROR_MESSAGE = "Property existence constraint requires Neo4j Enterprise Edition";

    @Override
    public void validateNodePropertyExistenceConstraint(Cursor<NodeItem> allNodes, int label, int propertyKey) throws CreateConstraintFailureException {
        throw this.propertyExistenceConstraintsNotAllowed(new NodePropertyExistenceConstraint(label, propertyKey));
    }

    @Override
    public void validateRelationshipPropertyExistenceConstraint(Cursor<RelationshipItem> allRels, int type, int key) throws CreateConstraintFailureException {
        throw this.propertyExistenceConstraintsNotAllowed(new RelationshipPropertyExistenceConstraint(type, key));
    }

    @Override
    public PropertyConstraint readConstraint(PropertyConstraintRule rule) {
        if (rule instanceof UniquePropertyConstraintRule) {
            return ((UniquePropertyConstraintRule)rule).toConstraint();
        }
        return this.readNonStandardConstraint(rule);
    }

    protected PropertyConstraint readNonStandardConstraint(PropertyConstraintRule rule) {
        throw new IllegalStateException(ERROR_MESSAGE);
    }

    private CreateConstraintFailureException propertyExistenceConstraintsNotAllowed(PropertyConstraint constraint) {
        return new CreateConstraintFailureException(constraint, (Throwable)new IllegalStateException(ERROR_MESSAGE));
    }

    @Override
    public PropertyConstraintRule writeUniquePropertyConstraint(long ruleId, int label, int propertyKey, long indexId) {
        return UniquePropertyConstraintRule.uniquenessConstraintRule(ruleId, label, propertyKey, indexId);
    }

    @Override
    public PropertyConstraintRule writeNodePropertyExistenceConstraint(long ruleId, int label, int propertyKey) throws CreateConstraintFailureException {
        throw this.propertyExistenceConstraintsNotAllowed(new NodePropertyExistenceConstraint(label, propertyKey));
    }

    @Override
    public PropertyConstraintRule writeRelationshipPropertyExistenceConstraint(long ruleId, int type, int key) throws CreateConstraintFailureException {
        throw this.propertyExistenceConstraintsNotAllowed(new RelationshipPropertyExistenceConstraint(type, key));
    }

    @Override
    public TxStateVisitor decorateTxStateVisitor(StoreReadLayer storeLayer, ReadableTransactionState txState, TxStateVisitor visitor) {
        return visitor;
    }
}

