/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexMapSnapshotProvider;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobFactory;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobQueue;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobTracker;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.kernel.impl.util.JobScheduler;

public class IndexSamplingController {
    private final IndexSamplingJobFactory jobFactory;
    private final IndexSamplingJobQueue<IndexDescriptor> jobQueue;
    private final IndexSamplingJobTracker jobTracker;
    private final IndexMapSnapshotProvider indexMapSnapshotProvider;
    private final JobScheduler scheduler;
    private final Predicate<IndexDescriptor> indexRecoveryCondition;
    private final boolean backgroundSampling;
    private final Lock samplingLock = new ReentrantLock(true);
    private JobScheduler.JobHandle backgroundSamplingHandle;

    IndexSamplingController(IndexSamplingConfig config, IndexSamplingJobFactory jobFactory, IndexSamplingJobQueue<IndexDescriptor> jobQueue, IndexSamplingJobTracker jobTracker, IndexMapSnapshotProvider indexMapSnapshotProvider, JobScheduler scheduler, Predicate<IndexDescriptor> indexRecoveryCondition) {
        this.backgroundSampling = config.backgroundSampling();
        this.jobFactory = jobFactory;
        this.indexMapSnapshotProvider = indexMapSnapshotProvider;
        this.jobQueue = jobQueue;
        this.jobTracker = jobTracker;
        this.scheduler = scheduler;
        this.indexRecoveryCondition = indexRecoveryCondition;
    }

    public void sampleIndexes(IndexSamplingMode mode) {
        IndexMap indexMap = this.indexMapSnapshotProvider.indexMapSnapshot();
        this.jobQueue.addAll(!mode.sampleOnlyIfUpdated, indexMap.descriptors());
        this.scheduleSampling(mode, indexMap);
    }

    public void sampleIndex(IndexDescriptor descriptor, IndexSamplingMode mode) {
        IndexMap indexMap = this.indexMapSnapshotProvider.indexMapSnapshot();
        this.jobQueue.add(!mode.sampleOnlyIfUpdated, descriptor);
        this.scheduleSampling(mode, indexMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverIndexSamples() {
        this.samplingLock.lock();
        try {
            IndexMap indexMap = this.indexMapSnapshotProvider.indexMapSnapshot();
            Iterator<IndexDescriptor> descriptors = indexMap.descriptors();
            while (descriptors.hasNext()) {
                IndexDescriptor descriptor = descriptors.next();
                if (!this.indexRecoveryCondition.test(descriptor)) continue;
                this.sampleIndexOnCurrentThread(indexMap, descriptor);
            }
        }
        finally {
            this.samplingLock.unlock();
        }
    }

    private void scheduleSampling(IndexSamplingMode mode, IndexMap indexMap) {
        if (mode.blockUntilAllScheduled) {
            this.scheduleAllSampling(indexMap);
        } else {
            this.tryScheduleSampling(indexMap);
        }
    }

    private void tryScheduleSampling(IndexMap indexMap) {
        if (this.tryEmptyLock()) {
            try {
                while (this.jobTracker.canExecuteMoreSamplingJobs()) {
                    IndexDescriptor descriptor = this.jobQueue.poll();
                    if (descriptor == null) {
                        return;
                    }
                    this.sampleIndexOnTracker(indexMap, descriptor);
                }
            }
            finally {
                this.samplingLock.unlock();
            }
        }
    }

    private boolean tryEmptyLock() {
        try {
            return this.samplingLock.tryLock(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleAllSampling(IndexMap indexMap) {
        this.samplingLock.lock();
        try {
            Iterable<IndexDescriptor> descriptors = this.jobQueue.pollAll();
            for (IndexDescriptor descriptor : descriptors) {
                this.jobTracker.waitUntilCanExecuteMoreSamplingJobs();
                this.sampleIndexOnTracker(indexMap, descriptor);
            }
        }
        finally {
            this.samplingLock.unlock();
        }
    }

    private void sampleIndexOnTracker(IndexMap indexMap, IndexDescriptor descriptor) {
        IndexSamplingJob job = this.createSamplingJob(indexMap, descriptor);
        if (job != null) {
            this.jobTracker.scheduleSamplingJob(job);
        }
    }

    private void sampleIndexOnCurrentThread(IndexMap indexMap, IndexDescriptor descriptor) {
        IndexSamplingJob job = this.createSamplingJob(indexMap, descriptor);
        if (job != null) {
            job.run();
        }
    }

    private IndexSamplingJob createSamplingJob(IndexMap indexMap, IndexDescriptor descriptor) {
        IndexProxy proxy = indexMap.getIndexProxy(descriptor);
        if (proxy == null || proxy.getState() != InternalIndexState.ONLINE) {
            return null;
        }
        return this.jobFactory.create(proxy);
    }

    public void start() {
        if (this.backgroundSampling) {
            Runnable samplingRunner = () -> this.sampleIndexes(IndexSamplingMode.BACKGROUND_REBUILD_UPDATED);
            this.backgroundSamplingHandle = this.scheduler.scheduleRecurring(JobScheduler.Groups.indexSamplingController, samplingRunner, 10L, TimeUnit.SECONDS);
        }
    }

    public void awaitSamplingCompleted(long time, TimeUnit unit) throws InterruptedException {
        this.jobTracker.awaitAllJobs(time, unit);
    }

    public void stop() {
        if (this.backgroundSamplingHandle != null) {
            this.backgroundSamplingHandle.cancel(true);
        }
        this.jobTracker.stopAndAwaitAllJobs();
    }
}

