/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.IoProducerStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class ReadRelationshipRecordsBackwardsStep
extends IoProducerStep {
    private final RelationshipStore store;
    private final long highId;
    private long id;

    public ReadRelationshipRecordsBackwardsStep(StageControl control, Configuration config, RelationshipStore store) {
        super(control, config);
        this.store = store;
        this.highId = this.id = store.getHighId();
    }

    @Override
    protected Object nextBatchOrNull(long ticket, int batchSize) {
        int size = (int)Math.min((long)batchSize, this.id);
        RelationshipRecord[] batch = new RelationshipRecord[size];
        for (int i = 0; i < size; ++i) {
            batch[i] = new RelationshipRecord(--this.id);
            this.store.fillRecord(batch[i].getId(), batch[i], RecordLoad.CHECK);
        }
        return size > 0 ? batch : null;
    }

    @Override
    protected long position() {
        return (this.highId - this.id) * 34L;
    }
}

