/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.File;
import java.io.IOException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Format;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.BatchImporter;
import org.neo4j.unsafe.impl.batchimport.CalculateDenseNodesStage;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.CountingStoreUpdateMonitor;
import org.neo4j.unsafe.impl.batchimport.IdMapperPreparationStage;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.MemoryUsageStatsProvider;
import org.neo4j.unsafe.impl.batchimport.NodeCountsStage;
import org.neo4j.unsafe.impl.batchimport.NodeFirstRelationshipStage;
import org.neo4j.unsafe.impl.batchimport.NodeStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipCountsStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkbackStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipStage;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputCache;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;
import org.neo4j.unsafe.impl.batchimport.store.io.IoMonitor;

public class ParallelBatchImporter
implements BatchImporter {
    private final File storeDir;
    private final FileSystemAbstraction fileSystem;
    private final Configuration config;
    private final LogService logService;
    private final Log log;
    private final ExecutionMonitor executionMonitor;
    private final AdditionalInitialIds additionalInitialIds;
    private final Config dbConfig;

    public ParallelBatchImporter(File storeDir, FileSystemAbstraction fileSystem, Configuration config, LogService logService, ExecutionMonitor executionMonitor, AdditionalInitialIds additionalInitialIds, Config dbConfig) {
        this.storeDir = storeDir;
        this.fileSystem = fileSystem;
        this.config = config;
        this.logService = logService;
        this.dbConfig = dbConfig;
        this.log = logService.getInternalLogProvider().getLog(this.getClass());
        this.executionMonitor = executionMonitor;
        this.additionalInitialIds = additionalInitialIds;
    }

    public ParallelBatchImporter(File storeDir, Configuration config, LogService logService, ExecutionMonitor executionMonitor, Config dbConfig) {
        this(storeDir, (FileSystemAbstraction)new DefaultFileSystemAbstraction(), config, logService, ExecutionSupervisors.withDynamicProcessorAssignment(executionMonitor, config), AdditionalInitialIds.EMPTY, dbConfig);
    }

    @Override
    public void doImport(Input input) throws IOException {
        this.log.info("Import starting");
        NodeRelationshipCache nodeRelationshipCache = null;
        NodeLabelsCache nodeLabelsCache = null;
        long startTime = System.currentTimeMillis();
        boolean hasBadEntries = false;
        File badFile = new File(this.storeDir, "bad.log");
        CountingStoreUpdateMonitor storeUpdateMonitor = new CountingStoreUpdateMonitor();
        try (BatchingNeoStores neoStore = new BatchingNeoStores(this.fileSystem, this.storeDir, this.config, this.logService, this.additionalInitialIds, this.dbConfig);
             CountsAccessor.Updater countsUpdater = neoStore.getCountsStore().reset(neoStore.getLastCommittedTransactionId());
             InputCache inputCache = new InputCache(this.fileSystem, this.storeDir);){
            Collector badCollector = input.badCollector();
            IoMonitor writeMonitor = new IoMonitor(neoStore.getIoTracer());
            IdMapper idMapper = input.idMapper();
            IdGenerator idGenerator = input.idGenerator();
            nodeRelationshipCache = new NodeRelationshipCache(NumberArrayFactory.AUTO, this.config.denseNodeThreshold());
            MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(nodeRelationshipCache, idMapper);
            InputIterable<InputNode> nodes = input.nodes();
            InputIterable<InputRelationship> relationships = input.relationships();
            NodeStage nodeStage = new NodeStage(this.config, writeMonitor, nodes, idMapper, idGenerator, neoStore, inputCache, neoStore.getLabelScanStore(), storeUpdateMonitor, memoryUsageStats);
            CalculateDenseNodesStage calculateDenseNodesStage = new CalculateDenseNodesStage(this.config, relationships, nodeRelationshipCache, idMapper, badCollector, inputCache);
            if (idMapper.needsPreparation()) {
                this.executeStages(nodeStage);
                this.executeStages(new IdMapperPreparationStage(this.config, idMapper, nodes, inputCache, badCollector, memoryUsageStats));
                this.executeStages(calculateDenseNodesStage);
            } else {
                this.executeStages(nodeStage, calculateDenseNodesStage);
            }
            nodeRelationshipCache.fixateNodes();
            RelationshipStage relationshipStage = new RelationshipStage(this.config, writeMonitor, relationships.supportsMultiplePasses() ? relationships : inputCache.relationships(), idMapper, neoStore, nodeRelationshipCache, input.specificRelationshipIds(), storeUpdateMonitor);
            this.executeStages(relationshipStage);
            nodeRelationshipCache.fixateGroups();
            this.executeStages(new NodeFirstRelationshipStage(this.config, neoStore.getNodeStore(), neoStore.getRelationshipGroupStore(), nodeRelationshipCache, badCollector, neoStore.getLabelScanStore()));
            nodeRelationshipCache.clearRelationships();
            this.executeStages(new RelationshipLinkbackStage(this.config, neoStore.getRelationshipStore(), nodeRelationshipCache));
            nodeRelationshipCache.close();
            nodeRelationshipCache = null;
            nodeLabelsCache = new NodeLabelsCache(NumberArrayFactory.AUTO, neoStore.getLabelRepository().getHighId());
            memoryUsageStats = new MemoryUsageStatsProvider(nodeLabelsCache);
            this.executeStages(new NodeCountsStage(this.config, nodeLabelsCache, neoStore.getNodeStore(), neoStore.getLabelRepository().getHighId(), countsUpdater, memoryUsageStats));
            this.executeStages(new RelationshipCountsStage(this.config, nodeLabelsCache, neoStore.getRelationshipStore(), neoStore.getLabelRepository().getHighId(), neoStore.getRelationshipTypeRepository().getHighId(), countsUpdater, NumberArrayFactory.AUTO));
            long totalTimeMillis = System.currentTimeMillis() - startTime;
            this.executionMonitor.done(totalTimeMillis, storeUpdateMonitor.toString());
            this.log.info("Import completed, took " + Format.duration(totalTimeMillis) + ". " + storeUpdateMonitor);
            boolean bl = hasBadEntries = badCollector.badEntries() > 0;
            if (hasBadEntries) {
                this.log.warn("There were " + badCollector.badEntries() + " bad entries which were skipped " + "and logged into " + badFile.getAbsolutePath());
            }
        }
        catch (Throwable t) {
            this.log.error("Error during import", t);
            throw Exceptions.launderedException(IOException.class, t);
        }
        finally {
            if (nodeRelationshipCache != null) {
                nodeRelationshipCache.close();
            }
            if (nodeLabelsCache != null) {
                nodeLabelsCache.close();
            }
            if (!hasBadEntries) {
                this.fileSystem.deleteFile(badFile);
            }
        }
    }

    private void executeStages(Stage ... stages) {
        ExecutionSupervisors.superviseExecution(this.executionMonitor, this.config, stages);
    }
}

