/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication;

import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;

class DuplicatePropertyRemover {
    private final NodeStore nodeStore;
    private final PropertyStore propertyStore;

    DuplicatePropertyRemover(NodeStore nodeStore, PropertyStore propertyStore) {
        this.nodeStore = nodeStore;
        this.propertyStore = propertyStore;
    }

    public void fixUpPropertyLinksAroundUnusedRecord(NodeRecord nodeRecord, PropertyRecord duplicateRecord) {
        PropertyRecord property;
        assert (!duplicateRecord.iterator().hasNext());
        long headProp = nodeRecord.getNextProp();
        if (duplicateRecord.getId() == headProp) {
            nodeRecord.setNextProp(duplicateRecord.getNextProp());
            this.nodeStore.updateRecord(nodeRecord);
        }
        long previousRecordId = duplicateRecord.getPrevProp();
        long nextRecordId = duplicateRecord.getNextProp();
        if (previousRecordId != (long)Record.NO_PREVIOUS_PROPERTY.intValue()) {
            property = this.propertyStore.getRecord(previousRecordId);
            property.setNextProp(nextRecordId);
            this.propertyStore.updateRecord(property);
        }
        if (nextRecordId != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            property = this.propertyStore.getRecord(nextRecordId);
            property.setPrevProp(previousRecordId);
            this.propertyStore.updateRecord(property);
        }
    }
}

