/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;
import org.neo4j.kernel.impl.store.kvstore.HeaderField;

public abstract class Headers {
    public abstract <Value> Value get(HeaderField<Value> var1);

    public static Builder headersBuilder() {
        return new Builder(new HashMap());
    }

    <Value> void write(HeaderField<Value> field, BigEndianByteArrayBuffer target) {
        field.write(this.get(field), target);
    }

    abstract Set<HeaderField<?>> fields();

    private Headers() {
    }

    static Headers indexedHeaders(Map<HeaderField<?>, Integer> indexes, Object[] values) {
        return new Indexed(indexes, values);
    }

    public final int hashCode() {
        int hash = 0;
        for (HeaderField<?> field : this.fields()) {
            hash ^= field.hashCode();
        }
        return hash;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Headers) {
            Set<HeaderField<?>> those;
            Headers that = (Headers)obj;
            Set<HeaderField<?>> these = this.fields();
            if (((Object)these).equals(those = that.fields())) {
                for (HeaderField headerField : these) {
                    Object tat;
                    Object tis = this.get(headerField);
                    if (tis.equals(tat = that.get(headerField))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public final String toString() {
        StringBuilder result = new StringBuilder().append("Headers{");
        String pre = "";
        for (HeaderField<?> field : this.fields()) {
            result.append(pre).append(field).append(": ").append(this.get(field));
            pre = ", ";
        }
        return result.append("}").toString();
    }

    static Map<HeaderField<?>, Object> copy(Headers headers) {
        HashMap copy = new HashMap();
        for (HeaderField<?> field : headers.fields()) {
            copy.put(field, headers.get(field));
        }
        return copy;
    }

    private static class Simple
    extends Headers {
        private final Map<HeaderField<?>, Object> headers;

        Simple(Map<HeaderField<?>, Object> headers) {
            this.headers = headers;
        }

        @Override
        public <Value> Value get(HeaderField<Value> field) {
            return (Value)this.headers.get(field);
        }

        @Override
        Set<HeaderField<?>> fields() {
            return this.headers.keySet();
        }
    }

    private static class Indexed
    extends Headers {
        private final Map<HeaderField<?>, Integer> indexes;
        private final Object[] values;

        Indexed(Map<HeaderField<?>, Integer> indexes, Object[] values) {
            this.indexes = indexes;
            this.values = values;
        }

        @Override
        public <Value> Value get(HeaderField<Value> field) {
            Integer index = this.indexes.get(field);
            return (Value)(index == null ? null : this.values[index]);
        }

        @Override
        Set<HeaderField<?>> fields() {
            return this.indexes.keySet();
        }
    }

    public static class Builder {
        private final Map<HeaderField<?>, Object> headers;

        Builder(Map<HeaderField<?>, Object> headers) {
            this.headers = headers;
        }

        public final <Value> Builder put(HeaderField<Value> field, Value value) {
            this.headers.put(field, value);
            return this;
        }

        public final <Value> Value get(HeaderField<Value> field) {
            return (Value)this.headers.get(field);
        }

        public Headers headers() {
            return new Simple(new HashMap(this.headers));
        }
    }
}

