/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

public class Neo4jTypes {
    public static final AnyType NTAny = new AnyType();
    public static final TextType NTText = new TextType();
    public static final NumberType NTNumber = new NumberType();
    public static final IntegerType NTInteger = new IntegerType();
    public static final FloatType NTFloat = new FloatType();
    public static final BooleanType NTBoolean = new BooleanType();
    public static final MapType NTMap = new MapType();
    public static final NodeType NTNode = new NodeType();
    public static final RelationshipType NTRelationship = new RelationshipType();
    public static final PathType NTPath = new PathType();
    public static final int ORD_ANY = 0;
    public static final int ORD_TEXT = 1;
    public static final int ORD_NUMBER = 2;
    public static final int ORD_INTEGER = 3;
    public static final int ORD_FLOAT = 4;
    public static final int ORD_BOOLEAN = 5;
    public static final int ORD_LIST = 6;
    public static final int ORD_MAP = 7;
    public static final int ORD_NODE = 8;
    public static final int ORD_RELATIONSHIP = 9;
    public static final int ORD_PATH = 10;

    public static ListType NTList(AnyType innerType) {
        return new ListType(innerType);
    }

    public static class PathType
    extends AnyType {
        public PathType() {
            super(10, "Path");
        }
    }

    public static class RelationshipType
    extends MapType {
        public RelationshipType() {
            super(9, "Relationship");
        }
    }

    public static class NodeType
    extends MapType {
        public NodeType() {
            super(8, "Node");
        }
    }

    public static class MapType
    extends AnyType {
        public MapType() {
            super(7, "Map");
        }

        protected MapType(int ordinal, String name) {
            super(ordinal, name);
        }
    }

    public static class ListType
    extends AnyType {
        private final AnyType innerType;

        public ListType(AnyType innerType) {
            super(6, "Collection[" + innerType.toString() + "]");
            this.innerType = innerType;
        }

        public AnyType innerType() {
            return this.innerType;
        }
    }

    public static class BooleanType
    extends AnyType {
        public BooleanType() {
            super(5, "Boolean");
        }
    }

    public static class FloatType
    extends NumberType {
        public FloatType() {
            super(4, "Float");
        }
    }

    public static class IntegerType
    extends NumberType {
        public IntegerType() {
            super(3, "Integer");
        }
    }

    public static class NumberType
    extends AnyType {
        public NumberType() {
            super(2, "Number");
        }

        protected NumberType(int ordinal, String name) {
            super(ordinal, name);
        }
    }

    public static class TextType
    extends AnyType {
        public TextType() {
            super(1, "Text");
        }
    }

    public static class AnyType {
        private final int ordinal;
        private final String name;

        public int ordinal() {
            return this.ordinal;
        }

        public AnyType() {
            this(0, "Any");
        }

        protected AnyType(int ordinal, String name) {
            this.ordinal = ordinal;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

