/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalWritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.Receiver;
import org.neo4j.unsafe.impl.batchimport.input.ValueType;

abstract class InputEntityCacher<ENTITY extends InputEntity>
implements Receiver<ENTITY[], IOException> {
    protected final WritableLogChannel channel;
    private final WritableLogChannel header;
    private final StoreChannel storeChannel;
    private final StoreChannel headerChannel;
    private final int[] previousGroupIds;
    private short nextKeyId;
    private final Map<String, Short> tokens = new HashMap<String, Short>();

    protected InputEntityCacher(StoreChannel channel, StoreChannel header, int bufferSize, int groupSlots) throws IOException {
        this.storeChannel = channel;
        this.headerChannel = header;
        this.previousGroupIds = new int[groupSlots];
        for (int i = 0; i < groupSlots; ++i) {
            this.previousGroupIds[i] = Group.GLOBAL.id();
        }
        this.channel = new PhysicalWritableLogChannel(new PhysicalLogVersionedStoreChannel(channel, 0L, 0), bufferSize);
        this.header = new PhysicalWritableLogChannel(new PhysicalLogVersionedStoreChannel(header, 0L, 0), (int)ByteUnit.kibiBytes((long)8L));
    }

    @Override
    public void receive(ENTITY[] batch) throws IOException {
        for (ENTITY entity : batch) {
            this.writeEntity(entity);
        }
    }

    protected void writeEntity(ENTITY entity) throws IOException {
        if (((InputEntity)entity).hasFirstPropertyId()) {
            this.channel.putShort((short)-1).putLong(((InputEntity)entity).firstPropertyId());
        } else {
            Object[] properties = ((InputEntity)entity).properties();
            this.channel.putShort(Utils.safeCastLongToShort(properties.length / 2));
            for (int i = 0; i < properties.length; ++i) {
                String key = (String)properties[i++];
                Object value = properties[i];
                if (value == null) continue;
                this.writeToken(key);
                this.writeValue(value);
            }
        }
    }

    protected void writeGroup(Group group, int slot) throws IOException {
        if (group.id() == this.previousGroupIds[slot]) {
            this.channel.put((byte)0);
        } else {
            this.channel.put((byte)1);
            this.previousGroupIds[slot] = group.id();
            this.channel.putInt(this.previousGroupIds[slot]);
            this.writeToken(group.name());
        }
    }

    protected void writeValue(Object value) throws IOException {
        ValueType type = ValueType.typeOf(value);
        this.channel.put(type.id());
        type.write(value, this.channel);
    }

    protected void writeToken(String key) throws IOException {
        Short id = this.tokens.get(key);
        if (id == null) {
            short s = this.nextKeyId;
            this.nextKeyId = (short)(s + 1);
            id = s;
            this.tokens.put(key, id);
            this.header.put((byte)1);
            ValueType.stringType().write(key, this.header);
        }
        this.channel.putShort(id);
    }

    @Override
    public void close() throws IOException {
        this.header.put((byte)0);
        this.channel.putShort((short)-2);
        this.channel.close();
        this.header.close();
        this.storeChannel.close();
        this.headerChannel.close();
    }
}

