/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.Predicate;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.FilteringIOCursor;
import org.neo4j.kernel.impl.transaction.log.IOCursor;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReaderLogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.TransactionLogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;

public class DumpLogicalLog {
    private static final String TO_FILE = "tofile";
    private static final String TX_FILTER = "txfilter";
    private final FileSystemAbstraction fileSystem;
    private static final Printer SYSTEM_OUT_PRINTER = new Printer(){

        @Override
        public PrintStream getFor(String file) {
            return System.out;
        }

        @Override
        public void close() {
        }
    };

    public DumpLogicalLog(FileSystemAbstraction fileSystem) {
        this.fileSystem = fileSystem;
    }

    public void dump(String filenameOrDirectory, final PrintStream out, TimeZone timeZone, String regex) throws IOException {
        LogHeader logHeader;
        File firstFile;
        LogVersionBridge bridge;
        File file = new File(filenameOrDirectory);
        DumpLogicalLog.printFile(file, out);
        if (file.isDirectory()) {
            final PhysicalLogFiles logFiles = new PhysicalLogFiles(file, this.fileSystem);
            bridge = new ReaderLogVersionBridge(this.fileSystem, logFiles){

                @Override
                public LogVersionedStoreChannel next(LogVersionedStoreChannel channel) throws IOException {
                    LogVersionedStoreChannel next = super.next(channel);
                    if (next != channel) {
                        DumpLogicalLog.printFile(logFiles.getLogFileForVersion(next.getVersion()), out);
                    }
                    return next;
                }
            };
            firstFile = logFiles.getLogFileForVersion(logFiles.getLowestLogVersion());
        } else {
            firstFile = file;
            bridge = LogVersionBridge.NO_MORE_CHANNELS;
        }
        StoreChannel fileChannel = this.fileSystem.open(firstFile, "r");
        ByteBuffer buffer = ByteBuffer.allocateDirect(16);
        try {
            logHeader = LogHeaderReader.readLogHeader(buffer, (ReadableByteChannel)fileChannel, false);
        }
        catch (IOException ex) {
            out.println("Unable to read timestamp information, no records in logical log.");
            out.println(ex.getMessage());
            fileChannel.close();
            throw ex;
        }
        out.println("Logical log format: " + logHeader.logFormatVersion + " version: " + logHeader.logVersion + " with prev committed tx[" + logHeader.lastCommittedTxId + "]");
        PhysicalLogVersionedStoreChannel channel = new PhysicalLogVersionedStoreChannel(fileChannel, logHeader.logVersion, logHeader.logFormatVersion);
        ReadAheadLogChannel logChannel = new ReadAheadLogChannel(channel, bridge, 4096);
        VersionAwareLogEntryReader<ReadableLogChannel> entryReader = new VersionAwareLogEntryReader<ReadableLogChannel>();
        LogEntryCursor entryCursor = new LogEntryCursor(entryReader, logChannel);
        TransactionLogEntryCursor transactionCursor = new TransactionLogEntryCursor(entryCursor);
        try (IOCursor<LogEntry[]> cursor = regex == null ? transactionCursor : new FilteringIOCursor<LogEntry[]>(transactionCursor, new TransactionRegexCriteria(regex, timeZone));){
            while (cursor.next()) {
                for (LogEntry entry : cursor.get()) {
                    out.println(entry.toString(timeZone));
                }
            }
        }
    }

    private static void printFile(File file, PrintStream out) {
        out.println("=== " + file.getAbsolutePath() + " ===");
    }

    protected static boolean isAGraphDatabaseDirectory(String fileName) {
        File file = new File(fileName);
        return file.isDirectory() && new File(file, "neostore").exists();
    }

    public static void main(String[] args) throws IOException {
        Args arguments = Args.withFlags(TO_FILE).parse(args);
        TimeZone timeZone = DumpLogicalLog.parseTimeZoneConfig(arguments);
        String regex = arguments.get(TX_FILTER);
        try (Printer printer = DumpLogicalLog.getPrinter(arguments);){
            for (String fileAsString : arguments.orphans()) {
                new DumpLogicalLog((FileSystemAbstraction)new DefaultFileSystemAbstraction()).dump(fileAsString, printer.getFor(fileAsString), timeZone, regex);
            }
        }
    }

    public static Printer getPrinter(Args args) {
        boolean toFile = args.getBoolean(TO_FILE, false, true);
        return toFile ? new FilePrinter() : SYSTEM_OUT_PRINTER;
    }

    public static TimeZone parseTimeZoneConfig(Args arguments) {
        return TimeZone.getTimeZone(arguments.get("timezone", Format.DEFAULT_TIME_ZONE.getID()));
    }

    private static class FilePrinter
    implements Printer {
        private File directory;
        private PrintStream out;

        private FilePrinter() {
        }

        @Override
        public PrintStream getFor(String file) throws FileNotFoundException {
            File dir;
            File absoluteFile = new File(file).getAbsoluteFile();
            File file2 = dir = absoluteFile.isDirectory() ? absoluteFile : absoluteFile.getParentFile();
            if (!dir.equals(this.directory)) {
                this.safeClose();
                File dumpFile = new File(dir, "dump-logical-log.txt");
                System.out.println("Redirecting the output to " + dumpFile.getPath());
                this.out = new PrintStream(dumpFile);
                this.directory = dir;
            }
            return this.out;
        }

        private void safeClose() {
            if (this.out != null) {
                this.out.close();
            }
        }

        @Override
        public void close() {
            this.safeClose();
        }
    }

    public static interface Printer
    extends AutoCloseable {
        public PrintStream getFor(String var1) throws FileNotFoundException;

        @Override
        public void close();
    }

    protected class TransactionRegexCriteria
    implements Predicate<LogEntry[]> {
        protected Pattern pattern;
        private final TimeZone timeZone;

        TransactionRegexCriteria(String regex, TimeZone timeZone) {
            this.pattern = Pattern.compile(regex);
            this.timeZone = timeZone;
        }

        @Override
        public boolean accept(LogEntry[] transaction) {
            for (LogEntry entry : transaction) {
                if (!this.pattern.matcher(entry.toString(this.timeZone)).find()) continue;
                return true;
            }
            return false;
        }
    }
}

