/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.IllegalLogFormatException;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;

public class LogHeaderReader {
    public static LogHeader readLogHeader(FileSystemAbstraction fileSystem, File file) throws IOException {
        try (StoreChannel channel = fileSystem.open(file, "r");){
            LogHeader logHeader = LogHeaderReader.readLogHeader(ByteBuffer.allocateDirect(100000), (ReadableByteChannel)channel, true);
            return logHeader;
        }
    }

    public static LogHeader readLogHeader(ByteBuffer buffer, ReadableByteChannel channel, boolean strict) throws IOException {
        buffer.clear();
        buffer.limit(16);
        int read = channel.read(buffer);
        if (read != 16) {
            if (strict) {
                throw new IOException("Unable to read log version and last committed tx");
            }
            return null;
        }
        buffer.flip();
        long encodedLogVersions = buffer.getLong();
        byte logFormatVersion = LogHeaderReader.decodeLogFormatVersion(encodedLogVersions);
        long logVersion = LogHeaderReader.decodeLogVersion(encodedLogVersions);
        long previousCommittedTx = buffer.getLong();
        return new LogHeader(logFormatVersion, logVersion, previousCommittedTx);
    }

    public static long decodeLogVersion(long encLogVersion) throws IllegalLogFormatException {
        return encLogVersion & 0xFFFFFFFFFFFFFFL;
    }

    public static byte decodeLogFormatVersion(long encLogVersion) {
        return (byte)(encLogVersion >> 56 & 0xFFL);
    }
}

