/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Iterator;
import org.neo4j.kernel.impl.store.DynamicBlockSize;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.DynamicRecord;

class ExistingThenNewRecordAllocator
implements DynamicRecordAllocator {
    private final DynamicBlockSize blockSize;
    private final IdSequence idSequence;

    ExistingThenNewRecordAllocator(DynamicBlockSize blockSize, IdSequence idSequence) {
        this.blockSize = blockSize;
        this.idSequence = idSequence;
    }

    @Override
    public DynamicRecord nextUsedRecordOrNew(Iterator<DynamicRecord> recordsToUseFirst) {
        DynamicRecord record;
        if (recordsToUseFirst.hasNext()) {
            record = recordsToUseFirst.next();
            if (!record.inUse()) {
                record.setCreated();
            }
        } else {
            record = new DynamicRecord(this.idSequence.nextId());
            record.setCreated();
        }
        record.setInUse(true);
        return record;
    }

    @Override
    public int dataSize() {
        return this.blockSize.getBlockSize() - 8;
    }
}

