/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.function.LongPredicate;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.util.MovingAverage;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.ProcessingStats;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.stats.StepStats;

public abstract class AbstractStep<T>
implements Step<T> {
    private final StageControl control;
    private volatile String name;
    protected volatile Step downstream;
    private volatile boolean endOfUpstream;
    protected volatile Throwable panic;
    private volatile boolean completed;
    protected int orderingGuarantees;
    protected final LongPredicate rightDoneTicket = new LongPredicate(){

        public boolean test(long ticket) {
            return AbstractStep.this.doneBatches.get() == ticket;
        }
    };
    protected final AtomicLong downstreamIdleTime = new AtomicLong();
    protected final AtomicLong upstreamIdleTime = new AtomicLong();
    protected final AtomicInteger queuedBatches = new AtomicInteger();
    protected final AtomicLong doneBatches = new AtomicLong();
    protected final MovingAverage totalProcessingTime;
    protected long startTime;
    protected long endTime;
    private final List<StatsProvider> additionalStatsProvider;

    public AbstractStep(StageControl control, String name, Configuration config, StatsProvider ... additionalStatsProvider) {
        this.control = control;
        this.name = name;
        this.totalProcessingTime = new MovingAverage(config.movingAverageSize());
        this.additionalStatsProvider = Arrays.asList(additionalStatsProvider);
    }

    @Override
    public void start(int orderingGuarantees) {
        this.orderingGuarantees = orderingGuarantees;
        this.resetStats();
    }

    protected boolean guarantees(int orderingGuaranteeFlag) {
        return (this.orderingGuarantees & orderingGuaranteeFlag) != 0;
    }

    @Override
    public int numberOfProcessors() {
        return 1;
    }

    @Override
    public boolean incrementNumberOfProcessors() {
        return false;
    }

    @Override
    public boolean decrementNumberOfProcessors() {
        return false;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void receivePanic(Throwable cause) {
        this.panic = cause;
    }

    protected boolean stillWorking() {
        if (this.panic != null) {
            return false;
        }
        return !this.endOfUpstream || this.queuedBatches.get() != 0;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    protected void issuePanic(Throwable cause) {
        this.issuePanic(cause, true);
    }

    protected void issuePanic(Throwable cause, boolean rethrow) {
        this.control.panic(cause);
        if (rethrow) {
            throw Exceptions.launderedException(cause);
        }
    }

    protected long await(LongPredicate predicate, long value) {
        if (predicate.test(value)) {
            return 0L;
        }
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 1000000 && !predicate.test(value); ++i) {
        }
        while (!predicate.test(value)) {
            try {
                Thread.sleep(1L);
                Thread.yield();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.assertHealthy();
        }
        return System.currentTimeMillis() - startTime;
    }

    protected void assertHealthy() {
        if (this.panic != null) {
            throw new RuntimeException("Panic called, so exiting", this.panic);
        }
    }

    @Override
    public void setDownstream(Step<?> downstream) {
        this.downstream = downstream;
    }

    @Override
    public StepStats stats() {
        ArrayList<StatsProvider> providers = new ArrayList<StatsProvider>();
        this.collectStatsProviders(providers);
        return new StepStats(this.name, this.stillWorking(), providers);
    }

    protected void collectStatsProviders(Collection<StatsProvider> into) {
        into.add(new ProcessingStats(this.doneBatches.get() + (long)this.queuedBatches.get(), this.doneBatches.get(), this.totalProcessingTime.total(), this.totalProcessingTime.average() / (long)this.numberOfProcessors(), this.upstreamIdleTime.get(), this.downstreamIdleTime.get()));
        into.addAll(this.additionalStatsProvider);
    }

    @Override
    public void endOfUpstream() {
        this.endOfUpstream = true;
        this.checkNotifyEndDownstream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkNotifyEndDownstream() {
        if (!this.stillWorking() && !this.isCompleted()) {
            AbstractStep abstractStep = this;
            synchronized (abstractStep) {
                if (!this.isCompleted()) {
                    if (this.downstream != null) {
                        this.downstream.endOfUpstream();
                    }
                    this.done();
                    this.completed = true;
                }
            }
        }
    }

    protected void done() {
        this.endTime = System.currentTimeMillis();
    }

    @Override
    public void close() throws Exception {
    }

    protected void changeName(String name) {
        this.name = name;
    }

    protected void resetStats() {
        this.downstreamIdleTime.set(0L);
        this.upstreamIdleTime.set(0L);
        this.queuedBatches.set(0);
        this.doneBatches.set(0L);
        this.totalProcessingTime.reset();
        this.startTime = System.currentTimeMillis();
        this.endTime = 0L;
    }

    public String toString() {
        return String.format("Step[%s, processors:%d, batches:%d", this.name, this.numberOfProcessors(), this.doneBatches.get());
    }
}

