/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.util.Iterator;
import org.neo4j.function.IntPredicates;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.StoreRelationshipIterable;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.store.NeoStore;

abstract class BatchRelationshipIterable<T>
implements Iterable<T>,
RelationshipVisitor<RuntimeException> {
    protected final StoreRelationshipIterable storeIterable;

    public BatchRelationshipIterable(NeoStore neoStore, long nodeId) {
        try {
            this.storeIterable = new StoreRelationshipIterable(neoStore, nodeId, IntPredicates.alwaysTrue(), Direction.BOTH);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException((Object)((Object)e.entityType()) + " " + e.entityId() + " not found");
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new PrefetchingIterator<T>(){
            private final RelationshipIterator storeIterator;
            {
                this.storeIterator = BatchRelationshipIterable.this.storeIterable.iterator();
            }

            @Override
            protected T fetchNextOrNull() {
                if (!this.storeIterator.hasNext()) {
                    return null;
                }
                long relationshipId = this.storeIterator.next();
                return BatchRelationshipIterable.this.nextFrom(relationshipId, this.storeIterator);
            }
        };
    }

    @Override
    public void visit(long relId, int type, long startNode, long endNode) throws RuntimeException {
        throw new UnsupportedOperationException("Should have been implemented by subclass using it");
    }

    protected abstract T nextFrom(long var1, RelationshipIterator var3);
}

