/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.Function;
import org.neo4j.function.primitive.FunctionFromPrimitiveLong;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.helpers.collection.ResourceClosingIterator;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.core.Token;

public class GlobalGraphOperations {
    private final NodeManager nodeManager;
    private final ThreadToStatementContextBridge statementCtxSupplier;
    private final RelationshipTypeTokenHolder relationshipTypes;

    private GlobalGraphOperations(GraphDatabaseService db) {
        GraphDatabaseAPI dbApi = (GraphDatabaseAPI)db;
        DependencyResolver resolver = dbApi.getDependencyResolver();
        this.nodeManager = resolver.resolveDependency(NodeManager.class);
        this.statementCtxSupplier = resolver.resolveDependency(ThreadToStatementContextBridge.class);
        this.relationshipTypes = resolver.resolveDependency(RelationshipTypeTokenHolder.class);
    }

    public static GlobalGraphOperations at(GraphDatabaseService db) {
        return new GlobalGraphOperations(db);
    }

    public ResourceIterable<Node> getAllNodes() {
        this.assertInUnterminatedTransaction();
        return new ResourceIterable<Node>(){

            @Override
            public ResourceIterator<Node> iterator() {
                final Statement statement = GlobalGraphOperations.this.statementCtxSupplier.get();
                final PrimitiveLongIterator ids = statement.readOperations().nodesGetAll();
                return new PrefetchingResourceIterator<Node>(){

                    @Override
                    public void close() {
                        statement.close();
                    }

                    @Override
                    protected Node fetchNextOrNull() {
                        assert (ids != null) : "ids null";
                        assert (GlobalGraphOperations.this.nodeManager != null) : "nodeManager null";
                        return ids.hasNext() ? GlobalGraphOperations.this.nodeManager.newNodeProxyById(ids.next()) : null;
                    }
                };
            }
        };
    }

    public Iterable<Relationship> getAllRelationships() {
        this.assertInUnterminatedTransaction();
        return new ResourceIterable<Relationship>(){

            @Override
            public ResourceIterator<Relationship> iterator() {
                final Statement statement = GlobalGraphOperations.this.statementCtxSupplier.get();
                final PrimitiveLongIterator ids = statement.readOperations().relationshipsGetAll();
                return new PrefetchingResourceIterator<Relationship>(){

                    @Override
                    public void close() {
                        statement.close();
                    }

                    @Override
                    protected Relationship fetchNextOrNull() {
                        return ids.hasNext() ? GlobalGraphOperations.this.nodeManager.newRelationshipProxy(ids.next()) : null;
                    }
                };
            }
        };
    }

    public Iterable<RelationshipType> getAllRelationshipTypes() {
        this.assertInUnterminatedTransaction();
        return Iterables.cast(this.relationshipTypes.getAllTokens());
    }

    public ResourceIterable<Label> getAllLabels() {
        this.assertInUnterminatedTransaction();
        return new ResourceIterable<Label>(){

            @Override
            public ResourceIterator<Label> iterator() {
                Statement statement = GlobalGraphOperations.this.statementCtxSupplier.get();
                return ResourceClosingIterator.newResourceIterator(statement, Iterables.map(new Function<Token, Label>(){

                    public Label apply(Token labelToken) {
                        return DynamicLabel.label(labelToken.name());
                    }
                }, statement.readOperations().labelsGetAllTokens()));
            }
        };
    }

    public ResourceIterable<String> getAllPropertyKeys() {
        this.assertInUnterminatedTransaction();
        return new ResourceIterable<String>(){

            @Override
            public ResourceIterator<String> iterator() {
                Statement statement = GlobalGraphOperations.this.statementCtxSupplier.get();
                return ResourceClosingIterator.newResourceIterator(statement, Iterables.map(new Function<Token, String>(){

                    public String apply(Token propertyToken) {
                        return propertyToken.name();
                    }
                }, statement.readOperations().propertyKeyGetAllTokens()));
            }
        };
    }

    @Deprecated
    public ResourceIterable<Node> getAllNodesWithLabel(final Label label) {
        this.assertInUnterminatedTransaction();
        return new ResourceIterable<Node>(){

            @Override
            public ResourceIterator<Node> iterator() {
                return GlobalGraphOperations.this.allNodesWithLabel(label.name());
            }
        };
    }

    private ResourceIterator<Node> allNodesWithLabel(String label) {
        Statement statement = this.statementCtxSupplier.get();
        int labelId = statement.readOperations().labelGetForName(label);
        if (labelId == -1) {
            statement.close();
            return IteratorUtil.emptyIterator();
        }
        PrimitiveLongIterator nodeIds = statement.readOperations().nodesGetForLabel(labelId);
        return ResourceClosingIterator.newResourceIterator(statement, PrimitiveLongCollections.map((FunctionFromPrimitiveLong)new FunctionFromPrimitiveLong<Node>(){

            public Node apply(long nodeId) {
                return GlobalGraphOperations.this.nodeManager.newNodeProxyById(nodeId);
            }
        }, (PrimitiveLongIterator)nodeIds));
    }

    private void assertInUnterminatedTransaction() {
        this.statementCtxSupplier.assertInUnterminatedTransaction();
    }
}

