/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring.tracing;

import org.neo4j.helpers.Service;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.kernel.monitoring.tracing.DefaultTracerFactory;
import org.neo4j.kernel.monitoring.tracing.TracerFactory;
import org.neo4j.logging.Log;

public class Tracers {
    public final PageCacheTracer pageCacheTracer;
    public final TransactionTracer transactionTracer;

    public Tracers(String desiredImplementationName, Log msgLog) {
        if ("null".equalsIgnoreCase(desiredImplementationName)) {
            this.pageCacheTracer = PageCacheTracer.NULL;
            this.transactionTracer = TransactionTracer.NULL;
        } else {
            TracerFactory foundFactory = new DefaultTracerFactory();
            boolean found = desiredImplementationName == null;
            for (TracerFactory factory : Service.load(TracerFactory.class)) {
                try {
                    if (!factory.getImplementationName().equalsIgnoreCase(desiredImplementationName)) continue;
                    foundFactory = factory;
                    found = true;
                    break;
                }
                catch (Exception e) {
                    msgLog.warn("Failed to instantiate desired tracer implementations '" + desiredImplementationName + "'", (Throwable)e);
                }
            }
            if (!found) {
                msgLog.warn("Using default tracer implementations instead of '%s'", new Object[]{desiredImplementationName});
            }
            this.pageCacheTracer = foundFactory.createPageCacheTracer();
            this.transactionTracer = foundFactory.createTransactionTracer();
        }
    }
}

