/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.diffsets;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.util.DiffApplyingPrimitiveIntIterator;
import org.neo4j.kernel.impl.util.DiffApplyingPrimitiveLongIterator;
import org.neo4j.kernel.impl.util.diffsets.ReadableDiffSets;
import org.neo4j.kernel.impl.util.diffsets.SuperDiffSets;

public class DiffSets<T>
extends SuperDiffSets<T, PrimitiveLongIterator>
implements ReadableDiffSets<T> {
    private static final DiffSets EMPTY = new DiffSets(Collections.emptySet(), Collections.emptySet()){

        @Override
        public Iterator apply(Iterator source) {
            return source;
        }

        @Override
        public PrimitiveLongIterator augment(PrimitiveLongIterator source) {
            return source;
        }

        @Override
        public PrimitiveIntIterator augment(PrimitiveIntIterator source) {
            return source;
        }

        @Override
        public PrimitiveLongIterator augmentWithRemovals(PrimitiveLongIterator source) {
            return source;
        }

        @Override
        public PrimitiveLongIterator augmentWithAdditions(PrimitiveLongIterator source) {
            return source;
        }

        @Override
        public DiffSets filterAdded(Predicate addedFilter) {
            return this;
        }

        @Override
        public DiffSets filter(Predicate filter) {
            return this;
        }
    };

    public static <T> DiffSets<T> emptyDiffSets() {
        return EMPTY;
    }

    public DiffSets() {
        this(null, null);
    }

    public DiffSets(Set<T> addedElements, Set<T> removedElements) {
        super(addedElements, removedElements);
    }

    @Override
    public PrimitiveLongIterator augment(PrimitiveLongIterator source) {
        return new DiffApplyingPrimitiveLongIterator(source, this.added(false), this.removed(false));
    }

    @Override
    public PrimitiveIntIterator augment(PrimitiveIntIterator source) {
        return new DiffApplyingPrimitiveIntIterator(source, this.added(false), this.removed(false));
    }

    @Override
    public PrimitiveLongIterator augmentWithRemovals(PrimitiveLongIterator source) {
        return new DiffApplyingPrimitiveLongIterator(source, Collections.emptySet(), this.removed(false));
    }

    @Override
    public PrimitiveLongIterator augmentWithAdditions(PrimitiveLongIterator source) {
        return new DiffApplyingPrimitiveLongIterator(source, this.added(false), Collections.emptySet());
    }

    @Override
    public DiffSets<T> filterAdded(Predicate<T> addedFilter) {
        return new DiffSets<T>(IteratorUtil.asSet(Iterables.filter(addedFilter, this.added(false))), IteratorUtil.asSet(this.removed(false)));
    }

    @Override
    public DiffSets<T> filter(Predicate<T> filter) {
        return new DiffSets<T>(IteratorUtil.asSet(Iterables.filter(filter, this.added(false))), IteratorUtil.asSet(Iterables.filter(filter, this.removed(false))));
    }
}

