/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.dbstructure;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.neo4j.helpers.Strings;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.util.dbstructure.ArgumentFormatter;

public enum DbStructureArgumentFormatter implements ArgumentFormatter
{
    INSTANCE;

    private static List<String> IMPORTS;

    @Override
    public Collection<String> imports() {
        return IMPORTS;
    }

    @Override
    public void formatArgument(Appendable builder, Object arg) throws IOException {
        if (arg == null) {
            builder.append("null");
        } else if (arg instanceof String) {
            builder.append('\"');
            Strings.escape(builder, arg.toString());
            builder.append('\"');
        } else if (arg instanceof Long) {
            builder.append(arg.toString());
            builder.append('l');
        } else if (arg instanceof Integer) {
            builder.append(arg.toString());
        } else if (arg instanceof Double) {
            double d = (Double)arg;
            if (Double.isNaN(d)) {
                builder.append("Double.NaN");
            } else if (Double.isInfinite(d)) {
                builder.append(d < 0.0 ? "Double.NEGATIVE_INFINITY" : "Double.POSITIVE_INFINITY");
            } else {
                builder.append(arg.toString());
                builder.append('d');
            }
        } else if (arg instanceof IndexDescriptor) {
            IndexDescriptor descriptor = (IndexDescriptor)arg;
            int labelId = descriptor.getLabelId();
            int propertyKeyId = descriptor.getPropertyKeyId();
            builder.append(String.format("new IndexDescriptor( %s, %s )", labelId, propertyKeyId));
        } else if (arg instanceof UniquenessConstraint) {
            UniquenessConstraint constraint = (UniquenessConstraint)arg;
            int labelId = constraint.label();
            int propertyKeyId = constraint.propertyKeyId();
            builder.append(String.format("new UniquenessConstraint( %s, %s )", labelId, propertyKeyId));
        } else {
            throw new IllegalArgumentException(String.format("Can't handle argument of type: %s with value: %s", arg.getClass(), arg));
        }
    }

    static {
        IMPORTS = Arrays.asList(UniquenessConstraint.class.getCanonicalName(), IndexDescriptor.class.getCanonicalName());
    }
}

