/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;

public enum DirectionWrapper {
    OUTGOING(Direction.OUTGOING){

        @Override
        public long getNextRel(RelationshipGroupRecord group) {
            return group.getFirstOut();
        }

        @Override
        public void setNextRel(RelationshipGroupRecord group, long firstNextRel) {
            group.setFirstOut(firstNextRel);
        }
    }
    ,
    INCOMING(Direction.INCOMING){

        @Override
        public long getNextRel(RelationshipGroupRecord group) {
            return group.getFirstIn();
        }

        @Override
        public void setNextRel(RelationshipGroupRecord group, long firstNextRel) {
            group.setFirstIn(firstNextRel);
        }
    }
    ,
    BOTH(Direction.BOTH){

        @Override
        public long getNextRel(RelationshipGroupRecord group) {
            return group.getFirstLoop();
        }

        @Override
        public void setNextRel(RelationshipGroupRecord group, long firstNextRel) {
            group.setFirstLoop(firstNextRel);
        }
    };

    private final Direction direction;

    private DirectionWrapper(Direction direction) {
        this.direction = direction;
    }

    public Direction direction() {
        return this.direction;
    }

    public abstract long getNextRel(RelationshipGroupRecord var1);

    public abstract void setNextRel(RelationshipGroupRecord var1, long var2);

    public static DirectionWrapper wrap(Direction direction) {
        switch (direction) {
            case OUTGOING: {
                return OUTGOING;
            }
            case INCOMING: {
                return INCOMING;
            }
            case BOTH: {
                return BOTH;
            }
        }
        throw new IllegalArgumentException("" + (Object)((Object)direction));
    }
}

