/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Iterator;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.state.PropertyTraverser;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;

public class PropertyCreator {
    private final DynamicRecordAllocator stringRecordAllocator;
    private final DynamicRecordAllocator arrayRecordAllocator;
    private final IdSequence propertyRecordIdGenerator;
    private final PropertyTraverser traverser;

    public PropertyCreator(PropertyStore propertyStore, PropertyTraverser traverser) {
        this(propertyStore.getStringStore(), propertyStore.getArrayStore(), propertyStore, traverser);
    }

    public PropertyCreator(DynamicRecordAllocator stringRecordAllocator, DynamicRecordAllocator arrayRecordAllocator, IdSequence propertyRecordIdGenerator, PropertyTraverser traverser) {
        this.stringRecordAllocator = stringRecordAllocator;
        this.arrayRecordAllocator = arrayRecordAllocator;
        this.propertyRecordIdGenerator = propertyRecordIdGenerator;
        this.traverser = traverser;
    }

    public <P extends PrimitiveRecord> void primitiveChangeProperty(RecordAccess.RecordProxy<Long, P, Void> primitiveRecordChange, int propertyKey, Object value, RecordAccess<Long, PropertyRecord, PrimitiveRecord> propertyRecords) {
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveRecordChange.forReadingLinkage();
        assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
        long propertyId = this.traverser.findPropertyRecordContaining(primitive, propertyKey, propertyRecords, true);
        PropertyRecord propertyRecord = propertyRecords.getOrLoad(propertyId, primitive).forChangingData();
        if (!propertyRecord.inUse()) {
            throw new IllegalStateException("Unable to change property[" + propertyId + "] since it has been deleted.");
        }
        PropertyBlock block = propertyRecord.getPropertyBlock(propertyKey);
        if (block == null) {
            throw new IllegalStateException("Property with index[" + propertyKey + "] is not present in property[" + propertyId + "]");
        }
        propertyRecord.setChanged(primitive);
        for (DynamicRecord record : block.getValueRecords()) {
            assert (record.inUse());
            record.setInUse(false, block.getType().intValue());
            propertyRecord.addDeletedRecord(record);
        }
        this.encodeValue(block, propertyKey, value);
        if (propertyRecord.size() > PropertyType.getPayloadSize()) {
            propertyRecord.removePropertyBlock(propertyKey);
            this.addPropertyBlockToPrimitive(block, primitiveRecordChange, propertyRecords);
        }
        assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
    }

    public PropertyBlock encodePropertyValue(int propertyKey, Object value) {
        return this.encodeValue(new PropertyBlock(), propertyKey, value);
    }

    public PropertyBlock encodeValue(PropertyBlock block, int propertyKey, Object value) {
        PropertyStore.encodeValue(block, propertyKey, value, this.stringRecordAllocator, this.arrayRecordAllocator);
        return block;
    }

    public <P extends PrimitiveRecord> void primitiveAddProperty(RecordAccess.RecordProxy<Long, P, Void> primitive, int propertyKey, Object value, RecordAccess<Long, PropertyRecord, PrimitiveRecord> propertyRecords) {
        PrimitiveRecord record = (PrimitiveRecord)primitive.forReadingLinkage();
        assert (this.traverser.assertPropertyChain(record, propertyRecords));
        PropertyBlock block = new PropertyBlock();
        this.encodeValue(block, propertyKey, value);
        this.addPropertyBlockToPrimitive(block, primitive, propertyRecords);
        assert (this.traverser.assertPropertyChain(record, propertyRecords));
    }

    private <P extends PrimitiveRecord> void addPropertyBlockToPrimitive(PropertyBlock block, RecordAccess.RecordProxy<Long, P, Void> primitiveRecordChange, RecordAccess<Long, PropertyRecord, PrimitiveRecord> propertyRecords) {
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveRecordChange.forReadingLinkage();
        assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
        int newBlockSizeInBytes = block.getSize();
        PropertyRecord host = null;
        long prop = primitive.getNextProp();
        while (prop != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            RecordAccess.RecordProxy<Long, PropertyRecord, PrimitiveRecord> change = propertyRecords.getOrLoad(prop, primitive);
            PropertyRecord propRecord = change.forReadingLinkage();
            assert (propRecord.inUse()) : propRecord;
            int propSize = propRecord.size();
            assert (propSize > 0) : propRecord;
            if (propSize + newBlockSizeInBytes <= PropertyType.getPayloadSize()) {
                host = propRecord = change.forChangingData();
                host.addPropertyBlock(block);
                host.setChanged(primitive);
                break;
            }
            prop = propRecord.getNextProp();
        }
        if (host == null) {
            host = propertyRecords.create(this.propertyRecordIdGenerator.nextId(), primitive).forChangingData();
            if (primitive.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
                PropertyRecord prevProp = propertyRecords.getOrLoad(primitive.getNextProp(), primitive).forChangingLinkage();
                assert (prevProp.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue());
                prevProp.setPrevProp(host.getId());
                host.setNextProp(prevProp.getId());
                prevProp.setChanged(primitive);
            }
            ((PrimitiveRecord)primitiveRecordChange.forChangingLinkage()).setNextProp(host.getId());
            host.addPropertyBlock(block);
            host.setInUse(true);
        }
        assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
    }

    public long createPropertyChain(PrimitiveRecord owner, Iterator<PropertyBlock> properties, RecordAccess<Long, PropertyRecord, PrimitiveRecord> propertyRecords) {
        if (properties == null || !properties.hasNext()) {
            return Record.NO_NEXT_PROPERTY.intValue();
        }
        PropertyRecord currentRecord = propertyRecords.create(this.propertyRecordIdGenerator.nextId(), owner).forChangingData();
        currentRecord.setInUse(true);
        currentRecord.setCreated();
        PropertyRecord firstRecord = currentRecord;
        while (properties.hasNext()) {
            PropertyBlock block = properties.next();
            if (currentRecord.size() + block.getSize() > PropertyType.getPayloadSize()) {
                PropertyRecord prevRecord = currentRecord;
                long propertyId = this.propertyRecordIdGenerator.nextId();
                currentRecord = propertyRecords.create(propertyId, owner).forChangingData();
                currentRecord.setInUse(true);
                currentRecord.setCreated();
                prevRecord.setNextProp(propertyId);
                currentRecord.setPrevProp(prevRecord.getId());
            }
            currentRecord.addPropertyBlock(block);
        }
        return firstRecord.getId();
    }

    public <P extends PrimitiveRecord> void setPrimitiveProperty(RecordAccess.RecordProxy<Long, P, Void> primitiveProxy, int key, Object value, RecordAccess<Long, PropertyRecord, PrimitiveRecord> propertyRecords) {
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveProxy.forReadingLinkage();
        long nextProp = primitive.getNextProp();
        PropertyBlock block = new PropertyBlock();
        this.encodeValue(block, key, value);
        int size = block.getSize();
        RecordAccess.RecordProxy<Long, PropertyRecord, PrimitiveRecord> thatFits = null;
        RecordAccess.RecordProxy<Long, PropertyRecord, PrimitiveRecord> thatHas = null;
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue() && (thatHas == null || thatFits == null)) {
            RecordAccess.RecordProxy<Long, PropertyRecord, PrimitiveRecord> current = propertyRecords.getOrLoad(nextProp, primitive);
            if (thatHas == null && current.forReadingLinkage().getPropertyBlock(key) != null) {
                thatHas = current;
                PropertyBlock removed = thatHas.forChangingData().removePropertyBlock(key);
                for (DynamicRecord dynRec : removed.getValueRecords()) {
                    dynRec.setInUse(false);
                    thatHas.forChangingData().addDeletedRecord(dynRec);
                }
            }
            if (thatFits == null && PropertyType.getPayloadSize() - current.forReadingLinkage().size() >= size) {
                thatFits = current;
            }
            nextProp = current.forReadingLinkage().getNextProp();
        }
        if (thatFits == null) {
            thatFits = propertyRecords.create(this.propertyRecordIdGenerator.nextId(), primitive);
            PropertyRecord thatFitsRecord = thatFits.forChangingData();
            thatFitsRecord.setInUse(true);
            if (primitive.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
                PropertyRecord first = propertyRecords.getOrLoad(primitive.getNextProp(), primitive).forChangingLinkage();
                thatFitsRecord.setNextProp(first.getId());
                first.setPrevProp(thatFitsRecord.getId());
            }
            ((PrimitiveRecord)primitiveProxy.forChangingLinkage()).setNextProp(thatFitsRecord.getId());
        }
        ((PropertyRecord)thatFits.forChangingData()).addPropertyBlock(block);
    }
}

