/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;

public class LogEntryWriterV1
implements LogEntryWriter {
    private final WritableLogChannel channel;
    private final Visitor<Command, IOException> serializer;

    public LogEntryWriterV1(WritableLogChannel channel, final NeoCommandHandler commandWriter) {
        this.channel = channel;
        this.serializer = new Visitor<Command, IOException>(){

            @Override
            public boolean visit(Command command) throws IOException {
                LogEntryWriterV1.this.writeLogEntryHeader((byte)3);
                command.handle(commandWriter);
                return false;
            }
        };
    }

    private void writeLogEntryHeader(byte type) throws IOException {
        this.channel.put((byte)-3).put(type);
    }

    @Override
    public void writeStartEntry(int masterId, int authorId, long timeWritten, long latestCommittedTxWhenStarted, byte[] additionalHeaderData) throws IOException {
        this.writeLogEntryHeader((byte)1);
        this.channel.putInt(masterId).putInt(authorId).putLong(timeWritten).putLong(latestCommittedTxWhenStarted).putInt(additionalHeaderData.length).put(additionalHeaderData, additionalHeaderData.length);
    }

    @Override
    public void writeCommitEntry(long transactionId, long timeWritten) throws IOException {
        this.writeLogEntryHeader((byte)5);
        this.channel.putLong(transactionId).putLong(timeWritten);
    }

    @Override
    public void serialize(TransactionRepresentation tx) throws IOException {
        tx.accept(this.serializer);
    }

    @Override
    public void writeCheckPointEntry(long transactionId, LogPosition logPosition) throws IOException {
        this.writeLogEntryHeader((byte)7);
        this.channel.putLong(transactionId).putLong(logPosition.getLogVersion()).putLong(logPosition.getByteOffset());
    }
}

