/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.standard;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.OverlappingFileLockException;
import org.neo4j.helpers.UTF8;
import org.neo4j.io.fs.FileLock;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.NotCurrentStoreVersionException;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.standard.StoreFormat;
import org.neo4j.kernel.impl.util.Charsets;
import org.neo4j.logging.Log;

public class StoreOpenCloseCycle {
    private final Log log;
    private final File dbFileName;
    private final StoreFormat<?, ?> format;
    private final FileSystemAbstraction fs;
    private FileLock fileLock;

    public StoreOpenCloseCycle(Log log, File dbFileName, StoreFormat<?, ?> format, FileSystemAbstraction fs) {
        this.log = log;
        this.dbFileName = dbFileName;
        this.format = format;
        this.fs = fs;
    }

    public boolean openStore(StoreChannel channel) throws IOException {
        this.lock(channel);
        StateDescription result = this.determineState(channel);
        StoreState state = result.state();
        switch (state) {
            case CLEAN: {
                channel.truncate(channel.size() - (long)UTF8.encode(this.footer()).length);
                return false;
            }
            case UNCLEAN: {
                return true;
            }
            case WRONG_VERSION: {
                throw new NotCurrentStoreVersionException(result.expectedFooter(), result.foundFooter(), "", false);
            }
        }
        throw new IllegalStateException("Unknown store state: " + (Object)((Object)state));
    }

    public void closeStore(final StoreChannel channel, final long highestIdInUse) throws IOException {
        FileUtils.windowsSafeIOOperation((FileUtils.FileOperation)new FileUtils.FileOperation(){

            public void perform() throws IOException {
                channel.position(highestIdInUse * (long)StoreOpenCloseCycle.this.format.recordSize(channel));
                ByteBuffer buffer = ByteBuffer.wrap(UTF8.encode(StoreOpenCloseCycle.this.footer()));
                channel.write(buffer);
                StoreOpenCloseCycle.this.log.debug("Closing " + StoreOpenCloseCycle.this.dbFileName + ", truncating at " + channel.position() + " vs file size " + channel.size());
                channel.truncate(channel.position());
                channel.force(false);
                if (StoreOpenCloseCycle.this.fileLock != null) {
                    StoreOpenCloseCycle.this.fileLock.release();
                    StoreOpenCloseCycle.this.fileLock = null;
                }
            }
        });
    }

    private void lock(StoreChannel channel) {
        try {
            this.fileLock = this.fs.tryLock(this.dbFileName, channel);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to lock store[" + this.dbFileName + "]", e);
        }
        catch (OverlappingFileLockException e) {
            throw new IllegalStateException("Unable to lock store [" + this.dbFileName + "], this is usually caused by another Neo4j kernel already running in " + "this JVM for this particular store");
        }
    }

    private StateDescription determineState(StoreChannel channel) throws IOException {
        assert (this.format.version().getBytes(Charsets.UTF_8).length == 6) : "Version must, for historical reasons, be 6 bytes long.";
        String expectedTypeAndVersion = this.footer();
        long fileSize = channel.size();
        byte[] expected = expectedTypeAndVersion.getBytes(Charsets.UTF_8);
        byte[] found = new byte[expected.length];
        ByteBuffer buffer = ByteBuffer.wrap(found);
        if (fileSize < (long)expected.length) {
            return new StateDescription(StoreState.UNCLEAN, expectedTypeAndVersion, "None");
        }
        int recordSize = this.format.recordSize(channel);
        if (recordSize != 0 && (fileSize - (long)expected.length) % (long)recordSize != 0L) {
            return new StateDescription(StoreState.UNCLEAN, expectedTypeAndVersion, "None");
        }
        channel.position(fileSize - (long)expected.length);
        channel.read(buffer);
        String foundTypeAndVersion = UTF8.decode(found);
        if (!expectedTypeAndVersion.equals(foundTypeAndVersion)) {
            if (foundTypeAndVersion.startsWith(this.format.type())) {
                return new StateDescription(StoreState.WRONG_VERSION, expectedTypeAndVersion, foundTypeAndVersion);
            }
            return new StateDescription(StoreState.UNCLEAN, expectedTypeAndVersion, foundTypeAndVersion);
        }
        return new StateDescription(StoreState.CLEAN, expectedTypeAndVersion, foundTypeAndVersion);
    }

    private String footer() {
        return this.format.type() + " " + this.format.version();
    }

    public static class StateDescription {
        private final StoreState state;
        private final String expectedFooter;
        private final String foundTypeAndVersion;

        public StateDescription(StoreState state, String expectedFooter, String foundTypeAndVersion) {
            this.state = state;
            this.expectedFooter = expectedFooter;
            this.foundTypeAndVersion = foundTypeAndVersion;
        }

        public StoreState state() {
            return this.state;
        }

        public String expectedFooter() {
            return this.expectedFooter;
        }

        public String foundFooter() {
            return this.foundTypeAndVersion;
        }
    }

    static enum StoreState {
        CLEAN,
        WRONG_VERSION,
        UNCLEAN;

    }
}

