/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.Abstract64BitRecord;
import org.neo4j.kernel.impl.store.record.Record;

public class DynamicRecord
extends Abstract64BitRecord {
    private static final int MAX_BYTES_IN_TO_STRING = 8;
    private static final int MAX_CHARS_IN_TO_STRING = 16;
    private byte[] data = null;
    private int length;
    private long nextBlock = Record.NO_NEXT_BLOCK.intValue();
    private int type;
    private boolean startRecord = true;

    public static DynamicRecord dynamicRecord(long id, boolean inUse) {
        DynamicRecord record = new DynamicRecord(id);
        record.setInUse(inUse);
        return record;
    }

    public static DynamicRecord dynamicRecord(long id, boolean inUse, boolean isStartRecord, long nextBlock, int type, byte[] data) {
        DynamicRecord record = new DynamicRecord(id);
        record.setInUse(inUse);
        record.setStartRecord(isStartRecord);
        record.setNextBlock(nextBlock);
        record.setType(type);
        record.setData(data);
        return record;
    }

    public DynamicRecord(long id) {
        super(id);
    }

    public void setStartRecord(boolean startRecord) {
        this.startRecord = startRecord;
    }

    public boolean isStartRecord() {
        return this.startRecord;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isLight() {
        return this.data == null;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public void setInUse(boolean inUse) {
        super.setInUse(inUse);
        if (!inUse) {
            this.data = null;
        }
    }

    public void setInUse(boolean inUse, int type) {
        this.type = type;
        this.setInUse(inUse);
    }

    public void setData(byte[] data) {
        this.length = data.length;
        this.data = data;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getNextBlock() {
        return this.nextBlock;
    }

    public void setNextBlock(long nextBlock) {
        this.nextBlock = nextBlock;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("DynamicRecord[").append(this.getId()).append(",used=").append(this.inUse()).append(",").append("light=").append(this.isLight()).append("(").append(this.length).append("),type=");
        PropertyType type = PropertyType.getPropertyType(this.type << 24, true);
        if (type == null) {
            buf.append(this.type);
        } else {
            buf.append(type.name());
        }
        buf.append(",data=");
        if (this.data != null) {
            if (type == PropertyType.STRING && this.data.length <= 16) {
                buf.append('\"');
                buf.append(PropertyStore.decodeString(this.data));
                buf.append("\",");
            } else {
                buf.append("byte[");
                if (this.data.length <= 8) {
                    for (int i = 0; i < this.data.length; ++i) {
                        if (i != 0) {
                            buf.append(',');
                        }
                        buf.append(this.data[i]);
                    }
                } else {
                    buf.append("size=").append(this.data.length);
                }
                buf.append("],");
            }
        } else {
            buf.append("null,");
        }
        buf.append("start=").append(this.startRecord);
        buf.append(",next=").append(this.nextBlock).append("]");
        return buf.toString();
    }

    @Override
    public DynamicRecord clone() {
        DynamicRecord result = new DynamicRecord(this.getLongId());
        if (this.data != null) {
            result.data = (byte[])this.data.clone();
        }
        result.setInUse(this.inUse());
        result.length = this.length;
        result.nextBlock = this.nextBlock;
        result.type = this.type;
        result.startRecord = this.startRecord;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DynamicRecord)) {
            return false;
        }
        return ((DynamicRecord)obj).getId() == this.getId();
    }

    @Override
    public int hashCode() {
        long id = this.getId();
        return (int)(id >>> 32 ^ id);
    }
}

