/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.AbstractRecordStore;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.Store;
import org.neo4j.kernel.impl.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

public class RelationshipStore
extends AbstractRecordStore<RelationshipRecord>
implements Store {
    public static final String TYPE_DESCRIPTOR = "RelationshipStore";
    public static final int RECORD_SIZE = 34;

    public RelationshipStore(File fileName, Config configuration, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fileSystemAbstraction, LogProvider logProvider, StoreVersionMismatchHandler versionMismatchHandler, Monitors monitors) {
        super(fileName, configuration, IdType.RELATIONSHIP, idGeneratorFactory, pageCache, fileSystemAbstraction, logProvider, versionMismatchHandler, monitors);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, RelationshipRecord record) throws FAILURE {
        processor.processRelationship(this, record);
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    public int getRecordSize() {
        return 34;
    }

    @Override
    public int getRecordHeaderSize() {
        return this.getRecordSize();
    }

    @Override
    public RelationshipRecord getRecord(long id) {
        RelationshipRecord record = new RelationshipRecord(id);
        return this.fillRecord(id, record, RecordLoad.NORMAL) ? record : null;
    }

    @Override
    public RelationshipRecord forceGetRecord(long id) {
        RelationshipRecord record = new RelationshipRecord(-1L);
        return this.fillRecord(id, record, RecordLoad.FORCE) ? record : null;
    }

    @Override
    public RelationshipRecord forceGetRaw(RelationshipRecord record) {
        return record;
    }

    @Override
    public RelationshipRecord forceGetRaw(long id) {
        return this.forceGetRecord(id);
    }

    public RelationshipRecord getLightRel(long id) {
        RelationshipRecord record = new RelationshipRecord(id);
        return this.fillRecord(id, record, RecordLoad.CHECK) ? record : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean fillRecord(long id, RelationshipRecord target, RecordLoad loadMode) {
        try (PageCursor cursor = this.storeFile.io(this.pageIdForRecord(id), 1);){
            boolean success = false;
            if (cursor.next()) {
                do {
                    success = this.readRecord(id, cursor, target);
                } while (cursor.shouldRetry());
            }
            if (!success) {
                if (loadMode == RecordLoad.NORMAL) {
                    throw new InvalidRecordException("RelationshipRecord[" + id + "] not in use");
                }
                if (loadMode == RecordLoad.CHECK) {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean inUse(long id) {
        long pageId = this.pageIdForRecord(id);
        int offset = this.offsetForId(id);
        try (PageCursor cursor = this.storeFile.io(pageId, 1);){
            boolean recordIsInUse = false;
            if (cursor.next()) {
                do {
                    cursor.setOffset(offset);
                    recordIsInUse = this.isInUse(cursor.getByte());
                } while (cursor.shouldRetry());
            }
            boolean bl = recordIsInUse;
            return bl;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public void forceUpdateRecord(RelationshipRecord record) {
        this.updateRecord(record, true);
    }

    @Override
    public void updateRecord(RelationshipRecord record) {
        this.updateRecord(record, false);
    }

    private void updateRecord(RelationshipRecord record, boolean force) {
        try (PageCursor cursor = this.storeFile.io(this.pageIdForRecord(record.getId()), 2);){
            if (cursor.next()) {
                do {
                    this.updateRecord(record, cursor, force);
                } while (cursor.shouldRetry());
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    private void updateRecord(RelationshipRecord record, PageCursor cursor, boolean force) {
        long id = record.getId();
        cursor.setOffset(this.offsetForId(id));
        if (record.inUse() || force) {
            long firstNode = record.getFirstNode();
            short firstNodeMod = (short)((firstNode & 0x700000000L) >> 31);
            long secondNode = record.getSecondNode();
            long secondNodeMod = (secondNode & 0x700000000L) >> 4;
            long firstPrevRel = record.getFirstPrevRel();
            long firstPrevRelMod = firstPrevRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (firstPrevRel & 0x700000000L) >> 7;
            long firstNextRel = record.getFirstNextRel();
            long firstNextRelMod = firstNextRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (firstNextRel & 0x700000000L) >> 10;
            long secondPrevRel = record.getSecondPrevRel();
            long secondPrevRelMod = secondPrevRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (secondPrevRel & 0x700000000L) >> 13;
            long secondNextRel = record.getSecondNextRel();
            long secondNextRelMod = secondNextRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (secondNextRel & 0x700000000L) >> 16;
            long nextProp = record.getNextProp();
            long nextPropMod = nextProp == (long)Record.NO_NEXT_PROPERTY.intValue() ? 0L : (nextProp & 0xF00000000L) >> 28;
            short inUseUnsignedByte = (short)((long)((record.inUse() ? Record.IN_USE : Record.NOT_IN_USE).byteValue() | firstNodeMod) | nextPropMod);
            int typeInt = (int)((long)record.getType() | secondNodeMod | firstPrevRelMod | firstNextRelMod | secondPrevRelMod | secondNextRelMod);
            long firstInStartNodeChain = record.isFirstInFirstChain() ? 1L : 0L;
            long firstInEndNodeChain = record.isFirstInSecondChain() ? 2L : 0L;
            byte extraByte = (byte)(firstInEndNodeChain | firstInStartNodeChain);
            cursor.putByte((byte)inUseUnsignedByte);
            cursor.putInt((int)firstNode);
            cursor.putInt((int)secondNode);
            cursor.putInt(typeInt);
            cursor.putInt((int)firstPrevRel);
            cursor.putInt((int)firstNextRel);
            cursor.putInt((int)secondPrevRel);
            cursor.putInt((int)secondNextRel);
            cursor.putInt((int)nextProp);
            cursor.putByte(extraByte);
        } else {
            cursor.putByte(Record.NOT_IN_USE.byteValue());
            this.freeId(id);
        }
    }

    private boolean readRecord(long id, PageCursor cursor, RelationshipRecord record) {
        cursor.setOffset(this.offsetForId(id));
        long inUseByte = cursor.getByte();
        boolean inUse = (inUseByte & 1L) == (long)Record.IN_USE.intValue();
        long firstNode = cursor.getUnsignedInt();
        long firstNodeMod = (inUseByte & 0xEL) << 31;
        long secondNode = cursor.getUnsignedInt();
        long typeInt = cursor.getInt();
        long secondNodeMod = (typeInt & 0x70000000L) << 4;
        int type = (int)(typeInt & 0xFFFFL);
        record.setId(id);
        record.setFirstNode(RelationshipStore.longFromIntAndMod(firstNode, firstNodeMod));
        record.setSecondNode(RelationshipStore.longFromIntAndMod(secondNode, secondNodeMod));
        record.setType(type);
        record.setInUse(inUse);
        long firstPrevRel = cursor.getUnsignedInt();
        long firstPrevRelMod = (typeInt & 0xE000000L) << 7;
        record.setFirstPrevRel(RelationshipStore.longFromIntAndMod(firstPrevRel, firstPrevRelMod));
        long firstNextRel = cursor.getUnsignedInt();
        long firstNextRelMod = (typeInt & 0x1C00000L) << 10;
        record.setFirstNextRel(RelationshipStore.longFromIntAndMod(firstNextRel, firstNextRelMod));
        long secondPrevRel = cursor.getUnsignedInt();
        long secondPrevRelMod = (typeInt & 0x380000L) << 13;
        record.setSecondPrevRel(RelationshipStore.longFromIntAndMod(secondPrevRel, secondPrevRelMod));
        long secondNextRel = cursor.getUnsignedInt();
        long secondNextRelMod = (typeInt & 0x70000L) << 16;
        record.setSecondNextRel(RelationshipStore.longFromIntAndMod(secondNextRel, secondNextRelMod));
        long nextProp = cursor.getUnsignedInt();
        long nextPropMod = (inUseByte & 0xF0L) << 28;
        byte extraByte = cursor.getByte();
        record.setFirstInFirstChain((extraByte & 1) != 0);
        record.setFirstInSecondChain((extraByte & 2) != 0);
        record.setNextProp(RelationshipStore.longFromIntAndMod(nextProp, nextPropMod));
        return inUse;
    }

    public boolean fillChainRecord(long id, RelationshipRecord record) {
        return this.fillRecord(id, record, RecordLoad.CHECK);
    }

    public static abstract class Configuration
    extends CommonAbstractStore.Configuration {
    }
}

