/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Service;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfigurablePageSwapperFactory;
import org.neo4j.logging.Log;

public class ConfiguringPageCacheFactory {
    private final PageSwapperFactory swapperFactory;
    private final Config config;
    private final PageCacheTracer tracer;
    private final Log log;
    private PageCache pageCache;

    public ConfiguringPageCacheFactory(FileSystemAbstraction fs, Config config, PageCacheTracer tracer, Log log) {
        this.swapperFactory = this.createAndConfigureSwapperFactory(fs, config);
        this.config = config;
        this.tracer = tracer;
        this.log = log;
    }

    private PageSwapperFactory createAndConfigureSwapperFactory(FileSystemAbstraction fs, Config config) {
        String desiredImplementation = config.get(GraphDatabaseSettings.pagecache_swapper);
        if (desiredImplementation != null) {
            for (PageSwapperFactory factory : Service.load(PageSwapperFactory.class)) {
                if (!factory.implementationName().equals(desiredImplementation)) continue;
                factory.setFileSystemAbstraction(fs);
                if (factory instanceof ConfigurablePageSwapperFactory) {
                    ConfigurablePageSwapperFactory cfactory = (ConfigurablePageSwapperFactory)factory;
                    cfactory.configure(config);
                }
                return factory;
            }
        }
        SingleFilePageSwapperFactory factory = new SingleFilePageSwapperFactory();
        factory.setFileSystemAbstraction(fs);
        return factory;
    }

    public synchronized PageCache getOrCreatePageCache() {
        if (this.pageCache == null) {
            this.pageCache = this.createPageCache();
        }
        return this.pageCache;
    }

    protected PageCache createPageCache() {
        return new MuninnPageCache(this.swapperFactory, this.calculateMaxPages(this.config), this.calculatePageSize(this.config), this.tracer);
    }

    public int calculateMaxPages(Config config) {
        long maxHeap;
        long pageCacheMemory = config.get(GraphDatabaseSettings.pagecache_memory);
        if (pageCacheMemory / (maxHeap = Runtime.getRuntime().maxMemory()) > 100L) {
            this.log.warn("The memory configuration looks unbalanced. It is generally recommended to have at least 10 KiB of heap memory, for every 1 MiB of page cache memory. The current configuration is allocating %s bytes for the page cache, and %s bytes for the heap.", new Object[]{pageCacheMemory, maxHeap});
        }
        long pageSize = config.get(GraphDatabaseSettings.mapped_memory_page_size);
        long pageCount = pageCacheMemory / pageSize;
        return (int)Math.min(2147481647L, pageCount);
    }

    public int calculatePageSize(Config config) {
        return config.get(GraphDatabaseSettings.mapped_memory_page_size).intValue();
    }

    public void dumpConfiguration() {
        long totalPhysicalMemory = this.totalPhysicalMemory();
        String totalPhysicalMemMb = totalPhysicalMemory == -1L ? "?" : "" + totalPhysicalMemory / 1024L / 1024L;
        long maxVmUsageMb = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        long pageCacheMb = this.calculateMaxPages(this.config) * this.calculatePageSize(this.config) / 1024 / 1024;
        String msg = "Physical mem: " + totalPhysicalMemMb + " MiB," + " Heap size: " + maxVmUsageMb + " MiB," + " Page cache size: " + pageCacheMb + " MiB.";
        this.log.info(msg);
    }

    public long totalPhysicalMemory() {
        try {
            Class<?> beanClass = Thread.currentThread().getContextClassLoader().loadClass("com.sun.management.OperatingSystemMXBean");
            Method method = beanClass.getMethod("getTotalPhysicalMemorySize", new Class[0]);
            return (Long)method.invoke((Object)ManagementFactory.getOperatingSystemMXBean(), new Object[0]);
        }
        catch (Exception | LinkageError e) {
            return -1L;
        }
    }
}

