/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.logging;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import org.neo4j.function.Consumer;
import org.neo4j.function.Consumers;
import org.neo4j.function.Supplier;
import org.neo4j.io.file.Files;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.logging.AbstractLogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.RotatingFileOutputStreamSupplier;

public class StoreLogService
extends AbstractLogService
implements Lifecycle {
    public static final String INTERNAL_LOG_NAME = "messages.log";
    private final Closeable closeable;
    private final SimpleLogService logService;

    public static Builder withUserLogProvider(LogProvider userLogProvider) {
        return new Builder().withUserLogProvider(userLogProvider);
    }

    public static Builder withRotation(long internalLogRotationThreshold, int internalLogRotationDelay, int maxInternalLogArchives, JobScheduler jobScheduler) {
        return new Builder().withRotation(internalLogRotationThreshold, internalLogRotationDelay, maxInternalLogArchives, jobScheduler);
    }

    public static StoreLogService inStoreDirectory(FileSystemAbstraction fileSystem, File storeDir) throws IOException {
        return new Builder().inStoreDirectory(fileSystem, storeDir);
    }

    private StoreLogService(LogProvider userLogProvider, FileSystemAbstraction fileSystem, File internalLog, long internalLogRotationThreshold, int internalLogRotationDelay, int maxInternalLogArchives, Executor rotationExecutor, final Consumer<LogProvider> rotationListener) throws IOException {
        FormattedLogProvider internalLogProvider;
        if (!internalLog.getParentFile().exists()) {
            internalLog.getParentFile().mkdirs();
        }
        if (internalLogRotationThreshold == 0L) {
            OutputStream outputStream = Files.createOrOpenAsOuputStream((FileSystemAbstraction)fileSystem, (File)internalLog, (boolean)true);
            internalLogProvider = FormattedLogProvider.withUTCTimeZone().toOutputStream(outputStream);
            rotationListener.accept((Object)internalLogProvider);
            this.closeable = outputStream;
        } else {
            RotatingFileOutputStreamSupplier rotatingSupplier = new RotatingFileOutputStreamSupplier(fileSystem, internalLog, internalLogRotationThreshold, internalLogRotationDelay, maxInternalLogArchives, rotationExecutor, new RotatingFileOutputStreamSupplier.RotationListener(){

                public void outputFileCreated(OutputStream newStream, OutputStream oldStream) {
                    FormattedLogProvider logProvider = FormattedLogProvider.withUTCTimeZone().toOutputStream(newStream);
                    ((FormattedLog)logProvider.getLog(StoreLogService.class)).info("Opened new internal log file");
                    rotationListener.accept((Object)logProvider);
                    ((FormattedLog)logProvider.getLog(StoreLogService.class)).info("Rotated internal log file");
                }
            });
            internalLogProvider = FormattedLogProvider.withUTCTimeZone().toOutputStream((Supplier)rotatingSupplier);
            this.closeable = rotatingSupplier;
        }
        this.logService = new SimpleLogService(userLogProvider, (LogProvider)internalLogProvider);
    }

    @Override
    public void init() throws Throwable {
    }

    @Override
    public void start() throws Throwable {
    }

    @Override
    public void stop() throws Throwable {
    }

    @Override
    public void shutdown() throws Throwable {
        this.closeable.close();
    }

    @Override
    public LogProvider getUserLogProvider() {
        return this.logService.getUserLogProvider();
    }

    @Override
    public LogProvider getInternalLogProvider() {
        return this.logService.getInternalLogProvider();
    }

    public static class Builder {
        private LogProvider userLogProvider = NullLogProvider.getInstance();
        private Executor rotationExecutor;
        private long internalLogRotationThreshold = 0L;
        private int internalLogRotationDelay = 0;
        private int maxInternalLogArchives = 0;
        private Consumer<LogProvider> rotationListener = Consumers.noop();

        public Builder withUserLogProvider(LogProvider userLogProvider) {
            this.userLogProvider = userLogProvider;
            return this;
        }

        public Builder withRotation(long internalLogRotationThreshold, int internalLogRotationDelay, int maxInternalLogArchives, JobScheduler jobScheduler) {
            return this.withRotation(internalLogRotationThreshold, internalLogRotationDelay, maxInternalLogArchives, jobScheduler.executor(JobScheduler.Groups.internalLogRotation));
        }

        public Builder withRotation(long internalLogRotationThreshold, int internalLogRotationDelay, int maxInternalLogArchives, Executor rotationExecutor) {
            this.internalLogRotationThreshold = internalLogRotationThreshold;
            this.internalLogRotationDelay = internalLogRotationDelay;
            this.maxInternalLogArchives = maxInternalLogArchives;
            this.rotationExecutor = rotationExecutor;
            return this;
        }

        public Builder withRotationListener(Consumer<LogProvider> rotationListener) {
            this.rotationListener = rotationListener;
            return this;
        }

        public StoreLogService inStoreDirectory(FileSystemAbstraction fileSystem, File storeDir) throws IOException {
            return this.toFile(fileSystem, new File(storeDir, StoreLogService.INTERNAL_LOG_NAME));
        }

        public StoreLogService toFile(FileSystemAbstraction fileSystem, File internalLogPath) throws IOException {
            return new StoreLogService(this.userLogProvider, fileSystem, internalLogPath, this.internalLogRotationThreshold, this.internalLogRotationDelay, this.maxInternalLogArchives, this.rotationExecutor, this.rotationListener);
        }
    }
}

