/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.neo4j.function.Consumer;
import org.neo4j.function.Supplier;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.StoreLocker;
import org.neo4j.kernel.StoreLockerLifecycleAdapter;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategies;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.StoreLogService;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.pagecache.PageCacheLifecycle;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.transaction.TransactionCounters;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.info.JvmChecker;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

public class PlatformModule {
    public final PageCache pageCache;
    public final Monitors monitors;
    public final GraphDatabaseFacade graphDatabaseFacade;
    public final Dependencies dependencies = new Dependencies(new Supplier<DependencyResolver>(){

        public DependencyResolver get() {
            return PlatformModule.this.dataSourceManager.getDataSource().getDependencyResolver();
        }
    });
    public final LogService logging;
    public final LifeSupport life = this.dependencies.satisfyDependency(this.createLife());
    public final File storeDir;
    public final DiagnosticsManager diagnosticsManager;
    public final Tracers tracers;
    public final Config config;
    public final FileSystemAbstraction fileSystem;
    public final DataSourceManager dataSourceManager;
    public final KernelExtensions kernelExtensions;
    public final JobScheduler jobScheduler;
    public final AvailabilityGuard availabilityGuard;
    public final TransactionCounters transactionMonitor;

    public PlatformModule(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies externalDependencies, GraphDatabaseFacade graphDatabaseFacade) {
        this.graphDatabaseFacade = this.dependencies.satisfyDependency(graphDatabaseFacade);
        this.config = this.dependencies.satisfyDependency(new Config(params, this.getSettingsClasses(externalDependencies.settingsClasses(), externalDependencies.kernelExtensions())));
        this.storeDir = storeDir.getAbsoluteFile();
        this.dependencies.satisfyDependency(new UsageData());
        this.fileSystem = this.life.add(this.dependencies.satisfyDependency(this.createFileSystemAbstraction()));
        this.monitors = externalDependencies.monitors() == null ? new Monitors() : externalDependencies.monitors();
        this.dependencies.satisfyDependency(this.monitors);
        this.jobScheduler = this.life.add(this.dependencies.satisfyDependency(this.createJobScheduler()));
        this.logging = this.life.add(this.dependencies.satisfyDependency(this.createLogService(externalDependencies.userLogProvider())));
        this.config.setLogger(this.logging.getInternalLog(Config.class));
        this.life.add(this.dependencies.satisfyDependency(new StoreLockerLifecycleAdapter(new StoreLocker(this.fileSystem), storeDir)));
        new JvmChecker(this.logging.getInternalLog(JvmChecker.class), new JvmMetadataRepository()).checkJvmCompatibilityAndIssueWarning();
        String desiredImplementationName = this.config.get(GraphDatabaseFacadeFactory.Configuration.tracer);
        this.tracers = this.dependencies.satisfyDependency(new Tracers(desiredImplementationName, this.logging.getInternalLog(Tracers.class)));
        this.dependencies.satisfyDependency(this.tracers.pageCacheTracer);
        this.pageCache = this.dependencies.satisfyDependency(this.createPageCache(this.fileSystem, this.config, this.logging, this.tracers));
        this.life.add(new PageCacheLifecycle(this.pageCache));
        this.diagnosticsManager = this.life.add(this.dependencies.satisfyDependency(new DiagnosticsManager(this.logging.getInternalLog(DiagnosticsManager.class))));
        this.dataSourceManager = this.life.add(this.dependencies.satisfyDependency(new DataSourceManager()));
        this.availabilityGuard = new AvailabilityGuard(Clock.SYSTEM_CLOCK);
        this.transactionMonitor = this.dependencies.satisfyDependency(this.createTransactionCounters());
        KernelContext kernelContext = new KernelContext(){

            @Override
            public FileSystemAbstraction fileSystem() {
                return PlatformModule.this.fileSystem;
            }

            @Override
            public File storeDir() {
                return PlatformModule.this.storeDir;
            }
        };
        this.kernelExtensions = this.dependencies.satisfyDependency(new KernelExtensions(kernelContext, externalDependencies.kernelExtensions(), this.dependencies, UnsatisfiedDependencyStrategies.fail()));
        this.publishPlatformInfo(this.dependencies.resolveDependency(UsageData.class));
    }

    private void publishPlatformInfo(UsageData sysInfo) {
        sysInfo.set(UsageDataKeys.version, Version.getKernel().getReleaseVersion());
        sysInfo.set(UsageDataKeys.revision, Version.getKernel().getRevision());
        sysInfo.set(UsageDataKeys.operationalMode, UsageDataKeys.OperationalMode.ha);
    }

    public LifeSupport createLife() {
        return new LifeSupport();
    }

    protected FileSystemAbstraction createFileSystemAbstraction() {
        return new DefaultFileSystemAbstraction();
    }

    protected LogService createLogService(LogProvider userLogProvider) {
        StoreLogService logService;
        long internalLogRotationThreshold = this.config.get(GraphDatabaseSettings.store_internal_log_rotation_threshold);
        int internalLogRotationDelay = this.config.get(GraphDatabaseSettings.store_internal_log_rotation_delay);
        int internalLogMaxArchives = this.config.get(GraphDatabaseSettings.store_internal_log_max_archives);
        StoreLogService.Builder builder = StoreLogService.withRotation(internalLogRotationThreshold, internalLogRotationDelay, internalLogMaxArchives, this.jobScheduler);
        if (userLogProvider != null) {
            builder.withUserLogProvider(userLogProvider);
        }
        builder.withRotationListener(new Consumer<LogProvider>(){

            public void accept(LogProvider logProvider) {
                PlatformModule.this.diagnosticsManager.dumpAll(logProvider.getLog(DiagnosticsManager.class));
            }
        });
        File internalLog = this.config.get(GraphDatabaseSettings.store_internal_log_location);
        try {
            logService = internalLog == null ? builder.inStoreDirectory(this.fileSystem, this.storeDir) : builder.toFile(this.fileSystem, internalLog);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return this.life.add(logService);
    }

    protected Neo4jJobScheduler createJobScheduler() {
        return new Neo4jJobScheduler(this.config.get(GraphDatabaseFacadeFactory.Configuration.editionName));
    }

    protected PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, LogService logging, Tracers tracers) {
        Log pageCacheLog = logging.getInternalLog(PageCache.class);
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, config, tracers.pageCacheTracer, pageCacheLog);
        PageCache pageCache = pageCacheFactory.getOrCreatePageCache();
        if (config.get(GraphDatabaseSettings.dump_configuration).booleanValue()) {
            pageCacheFactory.dumpConfiguration();
        }
        return pageCache;
    }

    protected TransactionCounters createTransactionCounters() {
        return new TransactionCounters();
    }

    private Iterable<Class<?>> getSettingsClasses(Iterable<Class<?>> settingsClasses, Iterable<KernelExtensionFactory<?>> kernelExtensions) {
        List<Class<?>> totalSettingsClasses = Iterables.toList(settingsClasses);
        for (KernelExtensionFactory<?> kernelExtension : kernelExtensions) {
            if (kernelExtension.getSettingsClass() == null) continue;
            totalSettingsClasses.add(kernelExtension.getSettingsClass());
        }
        return totalSettingsClasses;
    }
}

