/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import org.neo4j.concurrent.WorkSync;
import org.neo4j.helpers.Provider;
import org.neo4j.kernel.impl.api.CommandApplierFacade;
import org.neo4j.kernel.impl.api.CountsStoreApplier;
import org.neo4j.kernel.impl.api.LegacyIndexApplier;
import org.neo4j.kernel.impl.api.LegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.CacheInvalidationTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.HighIdTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.IndexTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.transaction.command.NeoStoreTransactionApplier;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.function.Optional;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class TransactionRepresentationStoreApplier {
    private final NeoStore neoStore;
    private final IndexingService indexingService;
    private final CacheAccessBackDoor cacheAccess;
    private final LockService lockService;
    private final Provider<LabelScanWriter> labelScanWriters;
    private final IndexConfigStore indexConfigStore;
    private final LegacyIndexApplierLookup legacyIndexProviderLookup;
    private final IdOrderingQueue legacyIndexTransactionOrdering;
    private final WorkSync<Provider<LabelScanWriter>, IndexTransactionApplier.LabelUpdateWork> labelScanStoreSync;

    public TransactionRepresentationStoreApplier(IndexingService indexingService, Provider<LabelScanWriter> labelScanWriters, NeoStore neoStore, CacheAccessBackDoor cacheAccess, LockService lockService, LegacyIndexApplierLookup legacyIndexProviderLookup, IndexConfigStore indexConfigStore, IdOrderingQueue legacyIndexTransactionOrdering) {
        this.indexingService = indexingService;
        this.labelScanWriters = labelScanWriters;
        this.neoStore = neoStore;
        this.cacheAccess = cacheAccess;
        this.lockService = lockService;
        this.legacyIndexProviderLookup = legacyIndexProviderLookup;
        this.indexConfigStore = indexConfigStore;
        this.legacyIndexTransactionOrdering = legacyIndexTransactionOrdering;
        this.labelScanStoreSync = new WorkSync(labelScanWriters);
    }

    public void apply(TransactionRepresentation representation, ValidatedIndexUpdates indexUpdates, LockGroup locks, long transactionId, TransactionApplicationMode mode) throws IOException {
        NeoCommandHandler storeApplier = new NeoStoreTransactionApplier(this.neoStore, this.cacheAccess, this.lockService, locks, transactionId);
        if (mode.needsIdTracking()) {
            storeApplier = new HighIdTransactionApplier(storeApplier, this.neoStore);
        }
        if (mode.needsCacheInvalidationOnUpdates()) {
            storeApplier = new CacheInvalidationTransactionApplier(storeApplier, this.neoStore, this.cacheAccess);
        }
        IndexTransactionApplier indexApplier = new IndexTransactionApplier(this.indexingService, indexUpdates, this.labelScanStoreSync);
        LegacyIndexApplier legacyIndexApplier = new LegacyIndexApplier(this.indexConfigStore, this.legacyIndexProviderLookup, this.legacyIndexTransactionOrdering, transactionId, mode);
        NeoCommandHandler countsStoreApplier = this.getCountsStoreApplier(transactionId, mode);
        try (CommandApplierFacade applier = new CommandApplierFacade(storeApplier, indexApplier, legacyIndexApplier, countsStoreApplier);){
            representation.accept(applier);
        }
    }

    private NeoCommandHandler getCountsStoreApplier(long transactionId, TransactionApplicationMode mode) {
        Optional<NeoCommandHandler> handlerOption = this.neoStore.getCounts().apply(transactionId).map(CountsStoreApplier.FACTORY);
        if (mode == TransactionApplicationMode.RECOVERY) {
            handlerOption = handlerOption.or(NeoCommandHandler.EMPTY);
        }
        return handlerOption.get();
    }

    public TransactionRepresentationStoreApplier withLegacyIndexTransactionOrdering(IdOrderingQueue legacyIndexTransactionOrdering) {
        return new TransactionRepresentationStoreApplier(this.indexingService, this.labelScanWriters, this.neoStore, this.cacheAccess, this.lockService, this.legacyIndexProviderLookup, this.indexConfigStore, legacyIndexTransactionOrdering);
    }
}

