/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.util.register.NeoRegister;
import org.neo4j.register.Register;

public class GuardingStatementOperations
implements EntityWriteOperations,
EntityReadOperations {
    private final EntityWriteOperations entityWriteDelegate;
    private final EntityReadOperations entityReadDelegate;
    private final Guard guard;

    public GuardingStatementOperations(EntityWriteOperations entityWriteDelegate, EntityReadOperations entityReadDelegate, Guard guard) {
        this.entityWriteDelegate = entityWriteDelegate;
        this.entityReadDelegate = entityReadDelegate;
        this.guard = guard;
    }

    @Override
    public long relationshipCreate(KernelStatement statement, int relationshipTypeId, long startNodeId, long endNodeId) throws EntityNotFoundException {
        this.guard.check();
        return this.entityWriteDelegate.relationshipCreate(statement, relationshipTypeId, startNodeId, endNodeId);
    }

    @Override
    public long nodeCreate(KernelStatement statement) {
        this.guard.check();
        return this.entityWriteDelegate.nodeCreate(statement);
    }

    @Override
    public void nodeDelete(KernelStatement state, long nodeId) throws EntityNotFoundException {
        this.guard.check();
        this.entityWriteDelegate.nodeDelete(state, nodeId);
    }

    @Override
    public void relationshipDelete(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        this.guard.check();
        this.entityWriteDelegate.relationshipDelete(state, relationshipId);
    }

    @Override
    public boolean nodeAddLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException, ConstraintValidationKernelException {
        this.guard.check();
        return this.entityWriteDelegate.nodeAddLabel(state, nodeId, labelId);
    }

    @Override
    public boolean nodeRemoveLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        return this.entityWriteDelegate.nodeRemoveLabel(state, nodeId, labelId);
    }

    @Override
    public Property nodeSetProperty(KernelStatement state, long nodeId, DefinedProperty property) throws EntityNotFoundException, ConstraintValidationKernelException {
        this.guard.check();
        return this.entityWriteDelegate.nodeSetProperty(state, nodeId, property);
    }

    @Override
    public Property relationshipSetProperty(KernelStatement state, long relationshipId, DefinedProperty property) throws EntityNotFoundException {
        this.guard.check();
        return this.entityWriteDelegate.relationshipSetProperty(state, relationshipId, property);
    }

    @Override
    public Property graphSetProperty(KernelStatement state, DefinedProperty property) {
        return this.entityWriteDelegate.graphSetProperty(state, property);
    }

    @Override
    public Property nodeRemoveProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException {
        this.guard.check();
        return this.entityWriteDelegate.nodeRemoveProperty(state, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipRemoveProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        this.guard.check();
        return this.entityWriteDelegate.relationshipRemoveProperty(state, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphRemoveProperty(KernelStatement state, int propertyKeyId) {
        this.guard.check();
        return this.entityWriteDelegate.graphRemoveProperty(state, propertyKeyId);
    }

    @Override
    public boolean nodeExists(KernelStatement state, long nodeId) {
        this.guard.check();
        return this.entityReadDelegate.nodeExists(state, nodeId);
    }

    @Override
    public boolean relationshipExists(KernelStatement statement, long relId) {
        this.guard.check();
        return this.entityReadDelegate.relationshipExists(statement, relId);
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        this.guard.check();
        return this.entityReadDelegate.nodesGetForLabel(state, labelId);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        this.guard.check();
        return this.entityReadDelegate.nodesGetFromIndexLookup(state, index, value);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexScan(KernelStatement state, IndexDescriptor index) throws IndexNotFoundKernelException {
        this.guard.check();
        return this.entityReadDelegate.nodesGetFromIndexScan(state, index);
    }

    @Override
    public long nodeGetUniqueFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        this.guard.check();
        return this.entityReadDelegate.nodeGetUniqueFromIndexLookup(state, index, value);
    }

    @Override
    public boolean nodeHasLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        this.guard.check();
        return this.entityReadDelegate.nodeHasLabel(state, nodeId, labelId);
    }

    @Override
    public PrimitiveIntIterator nodeGetLabels(KernelStatement state, long nodeId) throws EntityNotFoundException {
        this.guard.check();
        return this.entityReadDelegate.nodeGetLabels(state, nodeId);
    }

    @Override
    public Property nodeGetProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException {
        this.guard.check();
        return this.entityReadDelegate.nodeGetProperty(state, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipGetProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        this.guard.check();
        return this.entityReadDelegate.relationshipGetProperty(state, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphGetProperty(KernelStatement state, int propertyKeyId) {
        this.guard.check();
        return this.entityReadDelegate.graphGetProperty(state, propertyKeyId);
    }

    @Override
    public PrimitiveLongIterator nodeGetPropertyKeys(KernelStatement state, long nodeId) throws EntityNotFoundException {
        this.guard.check();
        return this.entityReadDelegate.nodeGetPropertyKeys(state, nodeId);
    }

    @Override
    public Iterator<DefinedProperty> nodeGetAllProperties(KernelStatement state, long nodeId) throws EntityNotFoundException {
        this.guard.check();
        return this.entityReadDelegate.nodeGetAllProperties(state, nodeId);
    }

    @Override
    public PrimitiveLongIterator relationshipGetPropertyKeys(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        this.guard.check();
        return this.entityReadDelegate.relationshipGetPropertyKeys(state, relationshipId);
    }

    @Override
    public Iterator<DefinedProperty> relationshipGetAllProperties(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        this.guard.check();
        return this.entityReadDelegate.relationshipGetAllProperties(state, relationshipId);
    }

    @Override
    public PrimitiveLongIterator graphGetPropertyKeys(KernelStatement state) {
        this.guard.check();
        return this.entityReadDelegate.graphGetPropertyKeys(state);
    }

    @Override
    public Iterator<DefinedProperty> graphGetAllProperties(KernelStatement state) {
        this.guard.check();
        return this.entityReadDelegate.graphGetAllProperties(state);
    }

    @Override
    public RelationshipIterator nodeGetRelationships(KernelStatement statement, long nodeId, Direction direction, int[] relTypes) throws EntityNotFoundException {
        this.guard.check();
        return this.entityReadDelegate.nodeGetRelationships(statement, nodeId, direction, relTypes);
    }

    @Override
    public RelationshipIterator nodeGetRelationships(KernelStatement statement, long nodeId, Direction direction) throws EntityNotFoundException {
        this.guard.check();
        return this.entityReadDelegate.nodeGetRelationships(statement, nodeId, direction);
    }

    @Override
    public int nodeGetDegree(KernelStatement statement, long nodeId, Direction direction, int relType) throws EntityNotFoundException {
        this.guard.check();
        return this.entityReadDelegate.nodeGetDegree(statement, nodeId, direction, relType);
    }

    @Override
    public int nodeGetDegree(KernelStatement statement, long nodeId, Direction direction) throws EntityNotFoundException {
        this.guard.check();
        return this.entityReadDelegate.nodeGetDegree(statement, nodeId, direction);
    }

    @Override
    public PrimitiveIntIterator nodeGetRelationshipTypes(KernelStatement statement, long nodeId) throws EntityNotFoundException {
        this.guard.check();
        return this.entityReadDelegate.nodeGetRelationshipTypes(statement, nodeId);
    }

    @Override
    public PrimitiveLongIterator nodesGetAll(KernelStatement state) {
        this.guard.check();
        return this.entityReadDelegate.nodesGetAll(state);
    }

    @Override
    public PrimitiveLongIterator relationshipsGetAll(KernelStatement state) {
        this.guard.check();
        return this.entityReadDelegate.relationshipsGetAll(state);
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(KernelStatement statement, long relId, RelationshipVisitor<EXCEPTION> visitor) throws EntityNotFoundException, EXCEPTION {
        this.guard.check();
        this.entityReadDelegate.relationshipVisit(statement, relId, visitor);
    }

    @Override
    public Cursor expand(KernelStatement statement, Cursor inputCursor, NeoRegister.Node.In nodeId, Register.Object.In<int[]> types, Register.Object.In<Direction> expandDirection, NeoRegister.Relationship.Out relId, NeoRegister.RelType.Out relType, Register.Object.Out<Direction> direction, NeoRegister.Node.Out startNodeId, NeoRegister.Node.Out neighborNodeId) {
        this.guard.check();
        return this.entityReadDelegate.expand(statement, inputCursor, nodeId, types, expandDirection, relId, relType, direction, startNodeId, neighborNodeId);
    }

    @Override
    public Cursor nodeGetRelationships(KernelStatement statement, long nodeId, Direction direction, RelationshipVisitor<? extends RuntimeException> visitor) throws EntityNotFoundException {
        this.guard.check();
        return this.entityReadDelegate.nodeGetRelationships(statement, nodeId, direction, new GuardedRelationshipVisitor<RuntimeException>(this.guard, visitor));
    }

    @Override
    public Cursor nodeGetRelationships(KernelStatement statement, long nodeId, Direction direction, int[] types, RelationshipVisitor<? extends RuntimeException> visitor) throws EntityNotFoundException {
        this.guard.check();
        return this.entityReadDelegate.nodeGetRelationships(statement, nodeId, direction, types, new GuardedRelationshipVisitor<RuntimeException>(this.guard, visitor));
    }

    private static class GuardedRelationshipVisitor<EX extends Exception>
    implements RelationshipVisitor<EX> {
        private final Guard guard;
        private final RelationshipVisitor<EX> visitor;

        public GuardedRelationshipVisitor(Guard guard, RelationshipVisitor<EX> visitor) {
            this.guard = guard;
            this.visitor = visitor;
        }

        @Override
        public void visit(long relId, int type, long startNode, long endNode) throws EX {
            this.guard.check();
            this.visitor.visit(relId, type, startNode, endNode);
        }
    }
}

