/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;

public class CacheInvalidationTransactionApplier
extends NeoCommandHandler.Adapter {
    private final RelationshipStore relationshipStore;
    private final NeoCommandHandler delegate;
    private final CacheAccessBackDoor cacheAccess;
    private final RelationshipTypeTokenStore relationshipTypeTokenStore;
    private final LabelTokenStore labelTokenStore;
    private final PropertyKeyTokenStore propertyKeyTokenStore;

    public CacheInvalidationTransactionApplier(NeoCommandHandler delegate, NeoStore neoStore, CacheAccessBackDoor cacheAccess) {
        this.delegate = delegate;
        this.cacheAccess = cacheAccess;
        this.relationshipStore = neoStore.getRelationshipStore();
        this.relationshipTypeTokenStore = neoStore.getRelationshipTypeTokenStore();
        this.labelTokenStore = neoStore.getLabelTokenStore();
        this.propertyKeyTokenStore = neoStore.getPropertyKeyTokenStore();
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        this.delegate.visitNodeCommand(command);
        this.cacheAccess.removeNodeFromCache(command.getKey());
        return false;
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
        this.delegate.visitRelationshipCommand(command);
        this.cacheAccess.removeRelationshipFromCache(command.getKey());
        RelationshipRecord record = command.getRecord();
        RelationshipRecord before = null;
        if (!record.inUse()) {
            before = this.relationshipStore.forceGetRaw(record.getId());
        }
        if (!record.inUse()) {
            if (before != null) {
                this.cacheAccess.removeNodeFromCache(before.getFirstNode());
                this.cacheAccess.removeNodeFromCache(before.getSecondNode());
            } else {
                this.cacheAccess.removeNodeFromCache(record.getFirstNode());
                this.cacheAccess.removeNodeFromCache(record.getSecondNode());
            }
        }
        return false;
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
        this.delegate.visitPropertyCommand(command);
        long nodeId = command.getNodeId();
        long relId = command.getRelId();
        if (nodeId != -1L) {
            this.cacheAccess.removeNodeFromCache(nodeId);
        } else if (relId != -1L) {
            this.cacheAccess.removeRelationshipFromCache(relId);
        }
        return false;
    }

    @Override
    public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
        return this.delegate.visitRelationshipGroupCommand(command);
    }

    @Override
    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) throws IOException {
        this.delegate.visitRelationshipTypeTokenCommand(command);
        Token type = this.relationshipTypeTokenStore.getToken((int)command.getKey());
        this.cacheAccess.addRelationshipTypeToken(type);
        return false;
    }

    @Override
    public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
        this.delegate.visitLabelTokenCommand(command);
        Token labelId = this.labelTokenStore.getToken((int)command.getKey());
        this.cacheAccess.addLabelToken(labelId);
        return false;
    }

    @Override
    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) throws IOException {
        this.delegate.visitPropertyKeyTokenCommand(command);
        Token index = this.propertyKeyTokenStore.getToken((int)command.getKey());
        this.cacheAccess.addPropertyKeyToken(index);
        return false;
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
        return this.delegate.visitSchemaRuleCommand(command);
    }

    @Override
    public boolean visitNeoStoreCommand(Command.NeoStoreCommand command) throws IOException {
        this.delegate.visitNeoStoreCommand(command);
        this.cacheAccess.removeGraphPropertiesFromCache();
        return false;
    }

    @Override
    public void apply() {
        this.delegate.apply();
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

