/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.state.StateDefaults;
import org.neo4j.kernel.impl.util.diffsets.DiffSets;
import org.neo4j.kernel.impl.util.diffsets.ReadableDiffSets;

public abstract class LabelState {
    private static final LabelState DEFAULT = new LabelState(){

        @Override
        public ReadableDiffSets<Long> nodeDiffSets() {
            return ReadableDiffSets.Empty.instance();
        }

        @Override
        public ReadableDiffSets<IndexDescriptor> indexChanges() {
            return ReadableDiffSets.Empty.instance();
        }

        @Override
        public ReadableDiffSets<IndexDescriptor> constraintIndexChanges() {
            return ReadableDiffSets.Empty.instance();
        }

        @Override
        public ReadableDiffSets<UniquenessConstraint> constraintsChanges() {
            return ReadableDiffSets.Empty.instance();
        }
    };

    public abstract ReadableDiffSets<Long> nodeDiffSets();

    public abstract ReadableDiffSets<IndexDescriptor> indexChanges();

    public abstract ReadableDiffSets<IndexDescriptor> constraintIndexChanges();

    public abstract ReadableDiffSets<UniquenessConstraint> constraintsChanges();

    private LabelState() {
    }

    static abstract class Defaults
    extends StateDefaults<Integer, LabelState, Mutable> {
        Defaults() {
        }

        @Override
        Mutable createValue(Integer key) {
            return new Mutable(key);
        }

        @Override
        LabelState defaultValue() {
            return DEFAULT;
        }
    }

    public static class Mutable
    extends LabelState {
        private DiffSets<Long> nodeDiffSets;
        private DiffSets<IndexDescriptor> indexChanges;
        private DiffSets<IndexDescriptor> constraintIndexChanges;
        private DiffSets<UniquenessConstraint> constraintsChanges;
        private final int labelId;

        private Mutable(int labelId) {
            this.labelId = labelId;
        }

        public int getLabelId() {
            return this.labelId;
        }

        @Override
        public ReadableDiffSets<Long> nodeDiffSets() {
            return ReadableDiffSets.Empty.ifNull(this.nodeDiffSets);
        }

        public DiffSets<Long> getOrCreateNodeDiffSets() {
            if (this.nodeDiffSets == null) {
                this.nodeDiffSets = new DiffSets();
            }
            return this.nodeDiffSets;
        }

        @Override
        public ReadableDiffSets<IndexDescriptor> indexChanges() {
            return ReadableDiffSets.Empty.ifNull(this.indexChanges);
        }

        public DiffSets<IndexDescriptor> getOrCreateIndexChanges() {
            if (this.indexChanges == null) {
                this.indexChanges = new DiffSets();
            }
            return this.indexChanges;
        }

        @Override
        public ReadableDiffSets<IndexDescriptor> constraintIndexChanges() {
            return ReadableDiffSets.Empty.ifNull(this.constraintIndexChanges);
        }

        public DiffSets<IndexDescriptor> getOrCreateConstraintIndexChanges() {
            if (this.constraintIndexChanges == null) {
                this.constraintIndexChanges = new DiffSets();
            }
            return this.constraintIndexChanges;
        }

        @Override
        public ReadableDiffSets<UniquenessConstraint> constraintsChanges() {
            return ReadableDiffSets.Empty.ifNull(this.constraintsChanges);
        }

        public DiffSets<UniquenessConstraint> getOrCreateConstraintsChanges() {
            if (this.constraintsChanges == null) {
                this.constraintsChanges = new DiffSets();
            }
            return this.constraintsChanges;
        }
    }
}

