/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.LogMarker;

public class BufferingLogger
extends StringLogger {
    private final Queue<LogMessage> buffer = new ConcurrentLinkedQueue<LogMessage>();

    @Override
    public void logMessage(String msg) {
        this.logMessage(msg, null, false);
    }

    @Override
    public void logMessage(String msg, Throwable throwable) {
        this.logMessage(msg, throwable, false);
    }

    @Override
    public void logMessage(String msg, boolean flush) {
        this.logMessage(msg, null, flush);
    }

    @Override
    public void logMessage(String msg, LogMarker marker) {
        this.logMessage(msg);
    }

    @Override
    public void logMessage(String msg, Throwable cause, boolean flush) {
        this.buffer.add(new LogMessage(msg, cause, flush));
    }

    @Override
    public void logLongMessage(String msg, Visitor<StringLogger.LineLogger, RuntimeException> source, boolean flush) {
        source.visit(new StringLogger.LineLoggerImpl(this));
    }

    @Override
    public void addRotationListener(Runnable listener) {
    }

    @Override
    protected void logLine(String line) {
        this.logMessage(line);
    }

    @Override
    public void flush() {
        this.logMessage("", true);
    }

    @Override
    public void close() {
    }

    public void replayInto(StringLogger other) {
        LogMessage message = this.buffer.poll();
        while (message != null) {
            if (message.throwable != null) {
                other.logMessage(message.message, message.throwable, message.flush);
            } else {
                other.logMessage(message.message, message.flush);
            }
            message = this.buffer.poll();
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter sb = new PrintWriter(stringWriter);
        for (LogMessage message : this.buffer) {
            sb.println(message.message);
            if (message.throwable == null) continue;
            message.throwable.printStackTrace(sb);
        }
        return stringWriter.toString();
    }

    private static class LogMessage {
        private final String message;
        private final Throwable throwable;
        private final boolean flush;

        public LogMessage(String message, Throwable throwable, boolean flush) {
            this.message = message;
            this.throwable = throwable;
            this.flush = flush;
        }
    }
}

