/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class HexPrinter {
    private final PrintStream out;
    private final int bytesPerLine;
    private final int maxLineNumberDigits;
    private int currentLineNumber;
    private int bytesOnThisLine;

    public HexPrinter(PrintStream out) {
        this(out, 8, 8);
    }

    public HexPrinter(PrintStream out, int maxLineNumberDigits, int bytesPerLine) {
        this.out = out;
        this.maxLineNumberDigits = maxLineNumberDigits;
        this.bytesPerLine = bytesPerLine;
    }

    public HexPrinter append(byte value) {
        this.checkNewLine();
        this.addHexValue(value);
        return this;
    }

    public void append(ReadableByteChannel source) throws IOException {
        this.append(source, -1);
    }

    public void append(ReadableByteChannel source, int atMost) throws IOException {
        boolean indefinite = atMost == -1;
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        block0: while (true) {
            int read;
            buffer.clear();
            if (!indefinite) {
                buffer.limit(Math.min(buffer.capacity(), atMost));
            }
            if ((read = source.read(buffer)) == -1) break;
            atMost -= read;
            buffer.flip();
            while (true) {
                if (!buffer.hasRemaining()) continue block0;
                this.append(buffer.get());
            }
            break;
        }
    }

    private void addHexValue(byte value) {
        this.out.append(" ").append(this.bytesOnThisLine > 1 && this.bytesOnThisLine % 8 == 1 ? " " : "").append(String.format("%X", (value & 0xF0) >> 4)).append(String.format("%X", value & 0xF));
    }

    private void addLineNumber() {
        String toAppend = String.valueOf(this.currentLineNumber);
        int zerosToPad = Math.max(0, this.maxLineNumberDigits - toAppend.length());
        while (zerosToPad-- > 0) {
            this.out.append('0');
        }
        this.out.append(toAppend);
    }

    private void checkNewLine() {
        if (this.bytesOnThisLine >= this.bytesPerLine) {
            this.out.println();
            this.bytesOnThisLine = 0;
            ++this.currentLineNumber;
        }
        if (this.bytesOnThisLine == 0) {
            this.addLineNumber();
        }
        ++this.bytesOnThisLine;
    }
}

