/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Collection;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.transaction.state.Loaders;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RecordAccessSet;
import org.neo4j.kernel.impl.transaction.state.RecordChanges;
import org.neo4j.kernel.impl.util.statistics.IntCounter;

public class RecordChangeSet
implements RecordAccessSet {
    private final RecordAccess<Long, NodeRecord, Void> nodeRecords;
    private final RecordAccess<Long, PropertyRecord, PrimitiveRecord> propertyRecords;
    private final RecordAccess<Long, RelationshipRecord, Void> relRecords;
    private final RecordAccess<Long, RelationshipGroupRecord, Integer> relGroupRecords;
    private final RecordAccess<Long, Collection<DynamicRecord>, SchemaRule> schemaRuleChanges;
    private final RecordAccess<Integer, PropertyKeyTokenRecord, Void> propertyKeyTokenChanges;
    private final RecordAccess<Integer, LabelTokenRecord, Void> labelTokenChanges;
    private final RecordAccess<Integer, RelationshipTypeTokenRecord, Void> relationshipTypeTokenChanges;
    private final IntCounter changeCounter = new IntCounter();

    public RecordChangeSet(NeoStore neoStore) {
        this(Loaders.nodeLoader(neoStore.getNodeStore()), Loaders.propertyLoader(neoStore.getPropertyStore()), Loaders.relationshipLoader(neoStore.getRelationshipStore()), Loaders.relationshipGroupLoader(neoStore.getRelationshipGroupStore()), Loaders.schemaRuleLoader(neoStore.getSchemaStore()), Loaders.propertyKeyTokenLoader(neoStore.getPropertyKeyTokenStore()), Loaders.labelTokenLoader(neoStore.getLabelTokenStore()), Loaders.relationshipTypeTokenLoader(neoStore.getRelationshipTypeTokenStore()));
    }

    public RecordChangeSet(RecordAccess.Loader<Long, NodeRecord, Void> nodeLoader, RecordAccess.Loader<Long, PropertyRecord, PrimitiveRecord> propertyLoader, RecordAccess.Loader<Long, RelationshipRecord, Void> relationshipLoader, RecordAccess.Loader<Long, RelationshipGroupRecord, Integer> relationshipGroupLoader, RecordAccess.Loader<Long, Collection<DynamicRecord>, SchemaRule> schemaRuleLoader, RecordAccess.Loader<Integer, PropertyKeyTokenRecord, Void> propertyKeyTokenLoader, RecordAccess.Loader<Integer, LabelTokenRecord, Void> labelTokenLoader, RecordAccess.Loader<Integer, RelationshipTypeTokenRecord, Void> relationshipTypeTokenLoader) {
        this.nodeRecords = new RecordChanges<Long, NodeRecord, Void>(nodeLoader, true, this.changeCounter);
        this.propertyRecords = new RecordChanges<Long, PropertyRecord, PrimitiveRecord>(propertyLoader, true, this.changeCounter);
        this.relRecords = new RecordChanges<Long, RelationshipRecord, Void>(relationshipLoader, false, this.changeCounter);
        this.relGroupRecords = new RecordChanges<Long, RelationshipGroupRecord, Integer>(relationshipGroupLoader, false, this.changeCounter);
        this.schemaRuleChanges = new RecordChanges<Long, Collection<DynamicRecord>, SchemaRule>(schemaRuleLoader, true, this.changeCounter);
        this.propertyKeyTokenChanges = new RecordChanges<Integer, PropertyKeyTokenRecord, Void>(propertyKeyTokenLoader, false, this.changeCounter);
        this.labelTokenChanges = new RecordChanges<Integer, LabelTokenRecord, Void>(labelTokenLoader, false, this.changeCounter);
        this.relationshipTypeTokenChanges = new RecordChanges<Integer, RelationshipTypeTokenRecord, Void>(relationshipTypeTokenLoader, false, this.changeCounter);
    }

    @Override
    public RecordAccess<Long, NodeRecord, Void> getNodeRecords() {
        return this.nodeRecords;
    }

    @Override
    public RecordAccess<Long, PropertyRecord, PrimitiveRecord> getPropertyRecords() {
        return this.propertyRecords;
    }

    @Override
    public RecordAccess<Long, RelationshipRecord, Void> getRelRecords() {
        return this.relRecords;
    }

    @Override
    public RecordAccess<Long, RelationshipGroupRecord, Integer> getRelGroupRecords() {
        return this.relGroupRecords;
    }

    @Override
    public RecordAccess<Long, Collection<DynamicRecord>, SchemaRule> getSchemaRuleChanges() {
        return this.schemaRuleChanges;
    }

    @Override
    public RecordAccess<Integer, PropertyKeyTokenRecord, Void> getPropertyKeyTokenChanges() {
        return this.propertyKeyTokenChanges;
    }

    @Override
    public RecordAccess<Integer, LabelTokenRecord, Void> getLabelTokenChanges() {
        return this.labelTokenChanges;
    }

    @Override
    public RecordAccess<Integer, RelationshipTypeTokenRecord, Void> getRelationshipTypeTokenChanges() {
        return this.relationshipTypeTokenChanges;
    }

    @Override
    public boolean hasChanges() {
        return this.changeCounter.value() > 0;
    }

    @Override
    public void close() {
        if (this.hasChanges()) {
            this.nodeRecords.close();
            this.propertyRecords.close();
            this.relRecords.close();
            this.schemaRuleChanges.close();
            this.relGroupRecords.close();
            this.propertyKeyTokenChanges.close();
            this.labelTokenChanges.close();
            this.relationshipTypeTokenChanges.close();
            this.changeCounter.clear();
        }
    }
}

