/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandReader;
import org.neo4j.kernel.impl.transaction.command.CommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.IdentifiableLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;

public enum LogEntryParsersV2 implements LogEntryParser<IdentifiableLogEntry>
{
    EMPTY{

        @Override
        public IdentifiableLogEntry parse(byte version, ReadableLogChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
            return null;
        }

        @Override
        public byte byteCode() {
            return 0;
        }

        @Override
        public boolean skip() {
            return false;
        }
    }
    ,
    TX_PREPARE{

        @Override
        public IdentifiableLogEntry parse(byte version, ReadableLogChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
            channel.getInt();
            channel.getLong();
            return null;
        }

        @Override
        public byte byteCode() {
            return 2;
        }

        @Override
        public boolean skip() {
            return true;
        }
    }
    ,
    TX_START{

        @Override
        public IdentifiableLogEntry parse(byte version, ReadableLogChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
            LogPosition position = marker.newPosition();
            byte globalIdLength = channel.get();
            byte branchIdLength = channel.get();
            channel.get(new byte[globalIdLength], globalIdLength);
            channel.get(new byte[branchIdLength], branchIdLength);
            int identifier = channel.getInt();
            channel.getInt();
            int masterId = channel.getInt();
            int authorId = channel.getInt();
            long timeWritten = channel.getLong();
            return new IdentifiableLogEntry(new LogEntryStart(masterId, authorId, timeWritten, -1L, LogEntryStart.EMPTY_ADDITIONAL_ARRAY, position), identifier);
        }

        @Override
        public byte byteCode() {
            return 1;
        }

        @Override
        public boolean skip() {
            return false;
        }
    }
    ,
    COMMAND{

        @Override
        public IdentifiableLogEntry parse(byte version, ReadableLogChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
            int identifier = channel.getInt();
            CommandReader commandReader = commandReaderFactory.newInstance((byte)2, version);
            Command command = commandReader.read(channel);
            return command == null ? null : new IdentifiableLogEntry(new LogEntryCommand(version, command), identifier);
        }

        @Override
        public byte byteCode() {
            return 3;
        }

        @Override
        public boolean skip() {
            return false;
        }
    }
    ,
    DONE{

        @Override
        public IdentifiableLogEntry parse(byte version, ReadableLogChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
            channel.getInt();
            return null;
        }

        @Override
        public byte byteCode() {
            return 4;
        }

        @Override
        public boolean skip() {
            return true;
        }
    }
    ,
    TX_1P_COMMIT{

        @Override
        public IdentifiableLogEntry parse(byte version, ReadableLogChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
            int identifier = channel.getInt();
            long txId = channel.getLong();
            long timeWritten = channel.getLong();
            return new IdentifiableLogEntry(new OnePhaseCommit(txId, timeWritten), identifier);
        }

        @Override
        public byte byteCode() {
            return 5;
        }

        @Override
        public boolean skip() {
            return false;
        }
    }
    ,
    TX_2P_COMMIT{

        @Override
        public IdentifiableLogEntry parse(byte version, ReadableLogChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
            int identifier = channel.getInt();
            long txId = channel.getLong();
            long timeWritten = channel.getLong();
            return new IdentifiableLogEntry(new OnePhaseCommit(txId, timeWritten), identifier);
        }

        @Override
        public byte byteCode() {
            return 6;
        }

        @Override
        public boolean skip() {
            return false;
        }
    };

}

