/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Collections;
import java.util.Set;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;

public class MultipleUnderlyingStorageExceptions
extends UnderlyingStorageException {
    public final Set<Pair<IndexDescriptor, UnderlyingStorageException>> exceptions;

    public MultipleUnderlyingStorageExceptions(Set<Pair<IndexDescriptor, UnderlyingStorageException>> exceptions) {
        super(MultipleUnderlyingStorageExceptions.buildMessage(exceptions));
        this.exceptions = Collections.unmodifiableSet(exceptions);
        for (Pair<IndexDescriptor, UnderlyingStorageException> exception : exceptions) {
            this.addSuppressed(exception.other());
        }
    }

    private static String buildMessage(Set<Pair<IndexDescriptor, UnderlyingStorageException>> exceptions) {
        StringBuilder builder = new StringBuilder();
        builder.append("Errors when closing (flushing) index updaters:");
        for (Pair<IndexDescriptor, UnderlyingStorageException> pair : exceptions) {
            builder.append(String.format(" (%s) %s", pair.first().toString(), pair.other().getMessage()));
        }
        return builder.toString();
    }
}

