/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.OverlappingFileLockException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileLock;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.InvalidIdGeneratorException;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.StoreNotFoundException;
import org.neo4j.kernel.impl.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class CommonAbstractStore
implements IdSequence,
AutoCloseable {
    public static final String ALL_STORES_VERSION = "v0.A.5";
    public static final String UNKNOWN_VERSION = "Unknown";
    protected final Config configuration;
    protected final PageCache pageCache;
    protected final File storageFileName;
    protected final IdType idType;
    private final IdGeneratorFactory idGeneratorFactory;
    private final StoreVersionMismatchHandler versionMismatchHandler;
    protected FileSystemAbstraction fileSystemAbstraction;
    protected StringLogger stringLogger;
    protected PagedFile storeFile;
    private IdGenerator idGenerator;
    private StoreChannel fileChannel;
    private boolean storeOk = true;
    private Throwable causeOfStoreNotOk;
    private FileLock fileLock;
    private String readTypeDescriptorAndVersion;

    public CommonAbstractStore(File fileName, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, StoreVersionMismatchHandler versionMismatchHandler) {
        this.storageFileName = fileName;
        this.configuration = configuration;
        this.idGeneratorFactory = idGeneratorFactory;
        this.pageCache = pageCache;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.idType = idType;
        this.stringLogger = stringLogger;
        this.versionMismatchHandler = versionMismatchHandler;
        try {
            this.checkStorage();
            this.checkVersion();
            this.loadStorage();
        }
        catch (Exception e) {
            if (this.storeFile != null) {
                try {
                    this.storeFile.close();
                }
                catch (IOException failureToClose) {
                    e.addSuppressed(failureToClose);
                }
            }
            this.releaseFileLockAndCloseFileChannel();
            throw Exceptions.launderedException(e);
        }
    }

    public static String buildTypeDescriptorAndVersion(String typeDescriptor) {
        return CommonAbstractStore.buildTypeDescriptorAndVersion(typeDescriptor, ALL_STORES_VERSION);
    }

    public static String buildTypeDescriptorAndVersion(String typeDescriptor, String version) {
        return typeDescriptor + " " + version;
    }

    protected static long longFromIntAndMod(long base, long modifier) {
        return modifier == 0L && base == 0xFFFFFFFFL ? -1L : base | modifier;
    }

    public String getTypeAndVersionDescriptor() {
        return CommonAbstractStore.buildTypeDescriptorAndVersion(this.getTypeDescriptor());
    }

    public abstract String getTypeDescriptor();

    protected void checkStorage() {
        if (!this.fileSystemAbstraction.fileExists(this.storageFileName)) {
            throw new StoreNotFoundException("No such store[" + this.storageFileName + "] in " + this.fileSystemAbstraction);
        }
        try {
            this.fileChannel = this.fileSystemAbstraction.open(this.storageFileName, "rw");
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to open file " + this.storageFileName, e);
        }
        try {
            this.fileLock = this.fileSystemAbstraction.tryLock(this.storageFileName, this.fileChannel);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to lock store[" + this.storageFileName + "]", e);
        }
        catch (OverlappingFileLockException e) {
            throw new IllegalStateException("Unable to lock store [" + this.storageFileName + "], this is usually caused by another Neo4j kernel already running in " + "this JVM for this particular store");
        }
    }

    protected void checkVersion() {
        try {
            this.verifyCorrectTypeDescriptorAndVersion();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to check version " + this.getStorageFileName(), e);
        }
    }

    protected void loadStorage() {
        try {
            this.readAndVerifyBlockSize();
            this.verifyFileSizeAndTruncate();
            try {
                int filePageSize = this.pageCache.pageSize() - this.pageCache.pageSize() % this.getEffectiveRecordSize();
                this.storeFile = this.pageCache.map(this.getStorageFileName(), filePageSize);
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
            this.loadIdGenerator();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to load storage " + this.getStorageFileName(), e);
        }
    }

    protected long pageIdForRecord(long id) {
        return id * (long)this.getEffectiveRecordSize() / (long)this.storeFile.pageSize();
    }

    protected int offsetForId(long id) {
        return (int)(id * (long)this.getEffectiveRecordSize() % (long)this.storeFile.pageSize());
    }

    protected int recordsPerPage() {
        return this.storeFile.pageSize() / this.getEffectiveRecordSize();
    }

    protected abstract int getEffectiveRecordSize();

    protected abstract void verifyFileSizeAndTruncate() throws IOException;

    protected abstract void readAndVerifyBlockSize() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIdGenerator() {
        try {
            if (this.storeOk) {
                this.openIdGenerator();
            }
        }
        catch (InvalidIdGeneratorException e) {
            this.setStoreNotOk(e);
        }
        finally {
            if (!this.getStoreOk() && this.stringLogger != null) {
                this.stringLogger.debug(this.getStorageFileName() + " non clean shutdown detected");
            }
        }
    }

    protected void verifyCorrectTypeDescriptorAndVersion() throws IOException {
        String expectedTypeDescriptorAndVersion = this.getTypeAndVersionDescriptor();
        int length = UTF8.encode(expectedTypeDescriptorAndVersion).length;
        byte[] bytes = new byte[length];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long fileSize = this.getFileChannel().size();
        if (fileSize < (long)length) {
            this.setStoreNotOk(new IllegalStateException("Invalid file size " + fileSize + " for " + this + ". Expected " + length + " or bigger"));
            return;
        }
        this.getFileChannel().position(fileSize - (long)length);
        this.getFileChannel().read(buffer);
        this.readTypeDescriptorAndVersion = UTF8.decode(bytes);
        if (!expectedTypeDescriptorAndVersion.equals(this.readTypeDescriptorAndVersion)) {
            if (this.readTypeDescriptorAndVersion.startsWith(this.getTypeDescriptor())) {
                this.versionMismatchHandler.mismatch(ALL_STORES_VERSION, this.readTypeDescriptorAndVersion);
            } else {
                this.setStoreNotOk(new IllegalStateException("Unexpected version " + this.readTypeDescriptorAndVersion + ", expected " + expectedTypeDescriptorAndVersion));
            }
        }
    }

    protected abstract boolean isInUse(byte var1);

    protected void rebuildIdGenerator() {
        boolean fastRebuild;
        long defraggedCount;
        block18: {
            int blockSize = this.getEffectiveRecordSize();
            if (blockSize <= 0) {
                throw new InvalidRecordException("Illegal blockSize: " + blockSize);
            }
            this.stringLogger.debug("Rebuilding id generator for[" + this.getStorageFileName() + "] ...");
            this.closeIdGenerator();
            File idFile = new File(this.getStorageFileName().getPath() + ".id");
            if (this.fileSystemAbstraction.fileExists(idFile)) {
                boolean success = this.fileSystemAbstraction.deleteFile(idFile);
                assert (success) : "Couldn't delete " + idFile.getPath() + ", still open?";
            }
            this.createIdGenerator(idFile);
            this.openIdGenerator();
            defraggedCount = 0L;
            fastRebuild = this.doFastIdGeneratorRebuild();
            try {
                long foundHighId = this.findHighIdBackwards();
                this.setHighId(foundHighId);
                if (fastRebuild) break block18;
                try (PageCursor cursor = this.storeFile.io(0L, 10);){
                    defraggedCount = this.rebuildIdGeneratorSlow(cursor, this.recordsPerPage(), blockSize, foundHighId);
                }
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Unable to rebuild id generator " + this.getStorageFileName(), e);
            }
        }
        this.stringLogger.debug("[" + this.getStorageFileName() + "] high id=" + this.getHighId() + " (defragged=" + defraggedCount + ")");
        this.stringLogger.debug(this.getStorageFileName() + " rebuild id generator, highId=" + this.getHighId() + " defragged count=" + defraggedCount);
        if (!fastRebuild) {
            this.closeIdGenerator();
            this.openIdGenerator();
        }
    }

    private long rebuildIdGeneratorSlow(PageCursor cursor, int recordsPerPage, int blockSize, long foundHighId) throws IOException {
        long defragCount = 0L;
        long[] freedBatch = new long[recordsPerPage];
        int startingId = this.getNumberOfReservedLowIds();
        boolean done = false;
        while (!done && cursor.next()) {
            int i;
            int defragged;
            long idPageOffset = cursor.getCurrentPageId() * (long)recordsPerPage;
            block1: do {
                defragged = 0;
                done = false;
                for (i = startingId; i < recordsPerPage; ++i) {
                    int offset = i * blockSize;
                    cursor.setOffset(offset);
                    long recordId = idPageOffset + (long)i;
                    if (recordId >= foundHighId) {
                        done = true;
                        continue block1;
                    }
                    if (!this.isRecordInUse(cursor)) {
                        freedBatch[defragged++] = recordId;
                        continue;
                    }
                    if (!this.isRecordReserved(cursor)) continue;
                    cursor.setOffset(offset);
                    cursor.putByte(Record.NOT_IN_USE.byteValue());
                    cursor.putInt(0);
                    freedBatch[defragged++] = recordId;
                }
            } while (cursor.shouldRetry());
            for (i = 0; i < defragged; ++i) {
                this.freeId(freedBatch[i]);
            }
            defragCount += (long)defragged;
            startingId = 0;
        }
        return defragCount;
    }

    protected boolean doFastIdGeneratorRebuild() {
        return this.configuration.get(Configuration.rebuild_idgenerators_fast);
    }

    protected void closeStorage() {
    }

    protected void setStoreNotOk(Throwable cause) {
        this.storeOk = false;
        this.causeOfStoreNotOk = cause;
        this.idGenerator = null;
    }

    protected boolean getStoreOk() {
        return this.storeOk;
    }

    protected void checkStoreOk() {
        if (!this.storeOk) {
            throw Exceptions.launderedException(this.causeOfStoreNotOk);
        }
    }

    @Override
    public long nextId() {
        return this.idGenerator.nextId();
    }

    public void freeId(long id) {
        if (this.idGenerator != null) {
            this.idGenerator.freeId(id);
        }
    }

    public long getHighId() {
        return this.idGenerator != null ? this.idGenerator.getHighId() : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighId(long highId) {
        if (this.idGenerator != null) {
            IdGenerator idGenerator = this.idGenerator;
            synchronized (idGenerator) {
                if (highId > this.idGenerator.getHighId()) {
                    this.idGenerator.setHighId(highId);
                }
            }
        }
    }

    public void makeStoreOk() {
        if (!this.storeOk) {
            this.rebuildIdGenerator();
            this.storeOk = true;
            this.causeOfStoreNotOk = null;
        }
    }

    protected File getStoreDir() {
        return this.configuration.get(Configuration.store_dir);
    }

    public File getStorageFileName() {
        return this.storageFileName;
    }

    protected void openIdGenerator() {
        this.idGenerator = this.openIdGenerator(new File(this.storageFileName.getPath() + ".id"), this.idType.getGrabSize());
    }

    protected IdGenerator openIdGenerator(File fileName, int grabSize) {
        try {
            return this.idGeneratorFactory.open(this.fileSystemAbstraction, fileName, grabSize, this.getIdType(), this.findHighIdBackwards());
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to find high id by scanning backwards " + this.getStorageFileName(), e);
        }
    }

    protected long findHighIdBackwards() throws IOException {
        try (PageCursor cursor = this.storeFile.io(0L, 1);){
            long nextPageId = this.storeFile.getLastPageId();
            int recordsPerPage = this.recordsPerPage();
            int recordSize = this.getRecordSize();
            while (nextPageId >= 0L && cursor.next(nextPageId)) {
                --nextPageId;
                do {
                    int currentRecord = recordsPerPage;
                    while (currentRecord-- > 0) {
                        cursor.setOffset(currentRecord * recordSize);
                        long recordId = cursor.getCurrentPageId() * (long)recordsPerPage + (long)currentRecord;
                        if (!this.isRecordInUse(cursor)) continue;
                        long l = recordId + 1L;
                        return l;
                    }
                } while (cursor.shouldRetry());
            }
            long l = this.getNumberOfReservedLowIds();
            return l;
        }
    }

    public abstract int getRecordSize();

    protected boolean isRecordInUse(PageCursor cursor) {
        return this.isInUse(cursor.getByte());
    }

    protected boolean isRecordReserved(PageCursor cursor) {
        return false;
    }

    protected void createIdGenerator(File fileName) {
        this.idGeneratorFactory.create(this.fileSystemAbstraction, fileName, 0L);
    }

    protected void closeIdGenerator() {
        if (this.idGenerator != null) {
            this.idGenerator.close();
        }
    }

    public void flush() {
        try {
            this.storeFile.flushAndForce();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed to flush", e);
        }
    }

    @Override
    public void close() {
        if (this.fileChannel == null) {
            return;
        }
        this.closeStorage();
        try {
            this.storeFile.close();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed to close store file: " + this.getStorageFileName(), e);
        }
        if (this.idGenerator == null || !this.storeOk) {
            this.releaseFileLockAndCloseFileChannel();
            return;
        }
        final long highId = this.idGenerator.getHighId();
        final int recordSize = this.getEffectiveRecordSize();
        this.idGenerator.close();
        IOException storedIoe = null;
        try {
            FileUtils.windowsSafeIOOperation((FileUtils.FileOperation)new FileUtils.FileOperation(){

                public void perform() throws IOException {
                    CommonAbstractStore.this.fileChannel.position(highId * (long)recordSize);
                    ByteBuffer buffer = ByteBuffer.wrap(UTF8.encode(CommonAbstractStore.this.versionMismatchHandler.trailerToWrite(CommonAbstractStore.this.getTypeAndVersionDescriptor(), CommonAbstractStore.this.readTypeDescriptorAndVersion)));
                    CommonAbstractStore.this.fileChannel.write(buffer);
                    CommonAbstractStore.this.stringLogger.debug("Closing " + CommonAbstractStore.this.storageFileName + ", truncating at " + CommonAbstractStore.this.fileChannel.position() + " vs file size " + CommonAbstractStore.this.fileChannel.size());
                    CommonAbstractStore.this.fileChannel.truncate(CommonAbstractStore.this.fileChannel.position());
                    CommonAbstractStore.this.fileChannel.force(false);
                    CommonAbstractStore.this.releaseFileLockAndCloseFileChannel();
                }
            });
        }
        catch (IOException e) {
            storedIoe = e;
        }
        if (storedIoe != null) {
            throw new UnderlyingStorageException("Unable to close store " + this.getStorageFileName(), storedIoe);
        }
    }

    protected void releaseFileLockAndCloseFileChannel() {
        try {
            if (this.fileLock != null) {
                this.fileLock.release();
            }
            if (this.fileChannel != null) {
                this.fileChannel.close();
            }
        }
        catch (IOException e) {
            this.stringLogger.warn("Could not close [" + this.storageFileName + "]", e);
        }
        this.fileChannel = null;
    }

    protected final StoreChannel getFileChannel() {
        return this.fileChannel;
    }

    public long getHighestPossibleIdInUse() {
        if (this.idGenerator != null) {
            return this.idGenerator.getHighestPossibleIdInUse();
        }
        return this.calculateHighestIdInUseByLookingAtFileSize();
    }

    public void setHighestPossibleIdInUse(long highId) {
        this.setHighId(highId + 1L);
    }

    private long calculateHighestIdInUseByLookingAtFileSize() {
        try {
            return this.getFileChannel().size() / (long)this.getRecordSize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getNumberOfIdsInUse() {
        return this.idGenerator.getNumberOfIdsInUse();
    }

    public int getNumberOfReservedLowIds() {
        return 0;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public void logVersions(StringLogger.LineLogger logger) {
        logger.logLine("  " + this.getTypeAndVersionDescriptor());
    }

    public void logIdUsage(StringLogger.LineLogger lineLogger) {
        lineLogger.logLine(String.format("  %s: used=%s high=%s", this.getTypeDescriptor(), this.getNumberOfIdsInUse(), this.getHighestPossibleIdInUse()));
    }

    public void visitStore(Visitor<CommonAbstractStore, RuntimeException> visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static abstract class Configuration {
        public static final Setting<File> store_dir = InternalAbstractGraphDatabase.Configuration.store_dir;
        public static final Setting<File> neo_store = InternalAbstractGraphDatabase.Configuration.neo_store;
        public static final Setting<Boolean> rebuild_idgenerators_fast = GraphDatabaseSettings.rebuild_idgenerators_fast;
    }
}

