/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.function.Function;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.IndexCommandFactory;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.graphdb.index.LegacyIndexProviderTransaction;
import org.neo4j.kernel.api.LegacyIndex;
import org.neo4j.kernel.api.exceptions.legacyindex.LegacyIndexNotFoundKernelException;
import org.neo4j.kernel.api.txstate.LegacyIndexTransactionState;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.transaction.command.Command;

public class LegacyIndexTransactionStateImpl
implements LegacyIndexTransactionState,
IndexCommandFactory {
    private final Map<String, LegacyIndexProviderTransaction> transactions = new HashMap<String, LegacyIndexProviderTransaction>();
    private final IndexConfigStore indexConfigStore;
    private final Function<String, IndexImplementation> providerLookup;
    private IndexDefineCommand defineCommand;
    private final Map<String, List<IndexCommand>> nodeCommands = new HashMap<String, List<IndexCommand>>();
    private final Map<String, List<IndexCommand>> relationshipCommands = new HashMap<String, List<IndexCommand>>();

    public LegacyIndexTransactionStateImpl(IndexConfigStore indexConfigStore, Function<String, IndexImplementation> providerLookup) {
        this.indexConfigStore = indexConfigStore;
        this.providerLookup = providerLookup;
    }

    @Override
    public LegacyIndex nodeChanges(String indexName) throws LegacyIndexNotFoundKernelException {
        Map<String, String> configuration = this.indexConfigStore.get(Node.class, indexName);
        if (configuration == null) {
            throw new LegacyIndexNotFoundKernelException("Node index '" + indexName + " not found", new Object[0]);
        }
        String providerName = configuration.get("provider");
        IndexImplementation provider = (IndexImplementation)this.providerLookup.apply((Object)providerName);
        LegacyIndexProviderTransaction transaction = this.transactions.get(providerName);
        if (transaction == null) {
            transaction = provider.newTransaction(this);
            this.transactions.put(providerName, transaction);
        }
        return transaction.nodeIndex(indexName, configuration);
    }

    @Override
    public LegacyIndex relationshipChanges(String indexName) throws LegacyIndexNotFoundKernelException {
        Map<String, String> configuration = this.indexConfigStore.get(Relationship.class, indexName);
        if (configuration == null) {
            throw new LegacyIndexNotFoundKernelException("Relationship index '" + indexName + " not found", new Object[0]);
        }
        String providerName = configuration.get("provider");
        IndexImplementation provider = (IndexImplementation)this.providerLookup.apply((Object)providerName);
        LegacyIndexProviderTransaction transaction = this.transactions.get(providerName);
        if (transaction == null) {
            transaction = provider.newTransaction(this);
            this.transactions.put(providerName, transaction);
        }
        return transaction.relationshipIndex(indexName, configuration);
    }

    @Override
    public void extractCommands(Collection<Command> target) {
        if (this.defineCommand != null) {
            target.add(this.defineCommand);
            this.extractCommands(target, this.nodeCommands);
            this.extractCommands(target, this.relationshipCommands);
        }
        for (LegacyIndexProviderTransaction providerTransaction : this.transactions.values()) {
            providerTransaction.close();
        }
    }

    private void extractCommands(Collection<Command> target, Map<String, List<IndexCommand>> commandMap) {
        if (commandMap != null) {
            for (List<IndexCommand> commands : commandMap.values()) {
                target.addAll(commands);
            }
        }
    }

    private IndexDefineCommand definitions() {
        if (this.defineCommand == null) {
            this.defineCommand = new IndexDefineCommand();
        }
        return this.defineCommand;
    }

    private void addCommand(String indexName, IndexCommand command) {
        this.addCommand(indexName, command, false);
    }

    private void addCommand(String indexName, IndexCommand command, boolean clearFirst) {
        List<IndexCommand> commands = null;
        if (command.getEntityType() == IndexEntityType.Node.id()) {
            commands = this.nodeCommands.get(indexName);
            if (commands == null) {
                commands = new ArrayList<IndexCommand>();
                this.nodeCommands.put(indexName, commands);
            }
        } else if (command.getEntityType() == IndexEntityType.Relationship.id()) {
            commands = this.nodeCommands.get(indexName);
            if (commands == null) {
                commands = new ArrayList<IndexCommand>();
                this.nodeCommands.put(indexName, commands);
            }
        } else {
            throw new IllegalArgumentException("" + command.getEntityType());
        }
        if (clearFirst) {
            commands.clear();
        }
        commands.add(command);
    }

    @Override
    public void addNode(String indexName, long id, String key, Object value) {
        IndexCommand.AddNodeCommand command = new IndexCommand.AddNodeCommand();
        command.init(this.definitions().getOrAssignIndexNameId(indexName), id, this.definitions().getOrAssignKeyId(key), value);
        this.addCommand(indexName, command);
    }

    @Override
    public void addRelationship(String indexName, long id, String key, Object value, long startNode, long endNode) {
        IndexCommand.AddRelationshipCommand command = new IndexCommand.AddRelationshipCommand();
        command.init(this.definitions().getOrAssignIndexNameId(indexName), id, this.definitions().getOrAssignKeyId(key), value, startNode, endNode);
        this.addCommand(indexName, command);
    }

    @Override
    public void removeNode(String indexName, long id, String keyOrNull, Object valueOrNull) {
        IndexCommand.RemoveCommand command = new IndexCommand.RemoveCommand();
        command.init(this.definitions().getOrAssignIndexNameId(indexName), IndexEntityType.Node.id(), id, this.definitions().getOrAssignKeyId(keyOrNull), valueOrNull);
        this.addCommand(indexName, command);
    }

    @Override
    public void removeRelationship(String indexName, long id, String keyOrNull, Object valueOrNull) {
        IndexCommand.RemoveCommand command = new IndexCommand.RemoveCommand();
        command.init(this.definitions().getOrAssignIndexNameId(indexName), IndexEntityType.Relationship.id(), id, this.definitions().getOrAssignKeyId(keyOrNull), valueOrNull);
        this.addCommand(indexName, command);
    }

    @Override
    public void deleteIndex(IndexEntityType entityType, String indexName) {
        IndexCommand.DeleteCommand command = new IndexCommand.DeleteCommand();
        command.init(this.definitions().getOrAssignIndexNameId(indexName), entityType.id());
        this.addCommand(indexName, command, true);
    }

    @Override
    public void createIndex(IndexEntityType entityType, String indexName, Map<String, String> config) {
        IndexCommand.CreateCommand command = new IndexCommand.CreateCommand();
        command.init(this.definitions().getOrAssignIndexNameId(indexName), entityType.id(), config);
        this.addCommand(indexName, command);
    }

    @Override
    public boolean hasChanges() {
        return this.defineCommand != null;
    }

    @Override
    public void initialize() {
        if (!this.transactions.isEmpty()) {
            this.transactions.clear();
        }
        this.defineCommand = null;
        if (!this.nodeCommands.isEmpty()) {
            this.nodeCommands.clear();
        }
        if (!this.relationshipCommands.isEmpty()) {
            this.relationshipCommands.clear();
        }
    }
}

