/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.index;

import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;

public class IndexCapacityExceededException
extends KernelException {
    private static final String RESERVATION_FAILED_MESSAGE = "Unable to reserve %d entries for insertion into index. Index contains too many entries. Current limitation is %d entries per index. Currently there are %d index entities.";
    private static final String INSERTION_FAILED_MESSAGE = "Index contains too many entries. Current limitation is %d indexed entities per index. Currently there are %d index entities.";

    public IndexCapacityExceededException(long reservation, long currentValue, long limit) {
        super((Status)Status.Schema.IndexLimitReached, RESERVATION_FAILED_MESSAGE, reservation, currentValue, limit);
    }

    public IndexCapacityExceededException(long currentValue, long limit) {
        super((Status)Status.Schema.IndexLimitReached, INSERTION_FAILED_MESSAGE, currentValue, limit);
    }
}

