/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.traversal;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;

class PostorderBreadthFirstSelector
implements BranchSelector {
    private Iterator<TraversalBranch> sourceIterator;
    private TraversalBranch current;
    private final PathExpander expander;

    PostorderBreadthFirstSelector(TraversalBranch startSource, PathExpander expander) {
        this.current = startSource;
        this.expander = expander;
    }

    @Override
    public TraversalBranch next(TraversalContext metadata) {
        if (this.sourceIterator == null) {
            this.sourceIterator = this.gatherSourceIterator(metadata);
        }
        return this.sourceIterator.hasNext() ? this.sourceIterator.next() : null;
    }

    private Iterator<TraversalBranch> gatherSourceIterator(TraversalContext metadata) {
        List<TraversalBranch> level;
        LinkedList<TraversalBranch> queue = new LinkedList<TraversalBranch>();
        queue.add(this.current.next(this.expander, metadata));
        while (!(level = this.gatherOneLevel(queue, metadata)).isEmpty()) {
            queue.addAll(0, level);
        }
        return queue.iterator();
    }

    private List<TraversalBranch> gatherOneLevel(List<TraversalBranch> queue, TraversalContext metadata) {
        LinkedList<TraversalBranch> level = new LinkedList<TraversalBranch>();
        Integer depth = null;
        for (TraversalBranch source : queue) {
            TraversalBranch next;
            if (depth == null) {
                depth = source.length();
            } else if (source.length() != depth.intValue()) break;
            while ((next = source.next(this.expander, metadata)) != null) {
                level.add(next);
            }
        }
        return level;
    }
}

