/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.StandardExpander;

public class PathExpanderBuilder {
    private final StandardExpander expander;

    public static PathExpanderBuilder empty() {
        return new PathExpanderBuilder(StandardExpander.EMPTY);
    }

    public static <STATE> PathExpanderBuilder allTypesAndDirections() {
        return new PathExpanderBuilder(StandardExpander.DEFAULT);
    }

    public static PathExpanderBuilder allTypes(Direction direction) {
        return new PathExpanderBuilder(StandardExpander.create(direction));
    }

    public PathExpanderBuilder add(RelationshipType type) {
        return this.add(type, Direction.BOTH);
    }

    public PathExpanderBuilder add(RelationshipType type, Direction direction) {
        return new PathExpanderBuilder(this.expander.add(type, direction));
    }

    public PathExpanderBuilder remove(RelationshipType type) {
        return new PathExpanderBuilder(this.expander.remove(type));
    }

    public <STATE> PathExpander<STATE> build() {
        return this.expander;
    }

    private PathExpanderBuilder(StandardExpander expander) {
        this.expander = expander;
    }
}

