/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.unsafe.impl.batchimport.cache.DynamicNumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.FixedLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class DynamicLongArray
extends DynamicNumberArray<LongArray>
implements LongArray {
    private final long defaultValue;

    public DynamicLongArray(NumberArrayFactory factory, long chunkSize, long defaultValue) {
        super(factory, chunkSize);
        this.defaultValue = defaultValue;
    }

    @Override
    public long get(long index) {
        LongArray chunk = (LongArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.get(this.index(index)) : this.defaultValue;
    }

    @Override
    public void set(long index, long value) {
        ((LongArray)this.ensureChunkAt(index)).set(this.index(index), value);
    }

    @Override
    public void swap(long fromIndex, long toIndex, int numberOfEntries) {
        for (int i = 0; i < numberOfEntries; ++i) {
            long intermediary = this.get(fromIndex + (long)i);
            this.set(fromIndex + (long)i, this.get(toIndex + (long)i));
            this.set(toIndex + (long)i, intermediary);
        }
    }

    @Override
    protected LongArray addChunk(long chunkSize) {
        return this.factory.newLongArray(chunkSize, this.defaultValue);
    }

    @Override
    public LongArray fixate() {
        return new FixedLongArray(this.chunks, this.chunkSize, this.defaultValue);
    }
}

