/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.Function;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.txstate.ReadableTxState;
import org.neo4j.kernel.api.txstate.RelationshipChangeVisitorAdapter;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateVisitor;
import org.neo4j.kernel.api.txstate.UpdateTriState;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.state.GraphState;
import org.neo4j.kernel.impl.api.state.LabelState;
import org.neo4j.kernel.impl.api.state.NodeState;
import org.neo4j.kernel.impl.api.state.PropertyChanges;
import org.neo4j.kernel.impl.api.state.PropertyContainerState;
import org.neo4j.kernel.impl.api.state.RelationshipChangesForNode;
import org.neo4j.kernel.impl.api.state.RelationshipState;
import org.neo4j.kernel.impl.util.diffsets.DiffSets;
import org.neo4j.kernel.impl.util.diffsets.DiffSetsVisitor;
import org.neo4j.kernel.impl.util.diffsets.ReadableDiffSets;

public final class TxState
implements TransactionState {
    private Map<Integer, LabelState.Mutable> labelStatesMap;
    private static final LabelState.Defaults LABEL_STATE = new LabelState.Defaults(){

        @Override
        Map<Integer, LabelState.Mutable> getMap(TxState state) {
            return state.labelStatesMap;
        }

        @Override
        void setMap(TxState state, Map<Integer, LabelState.Mutable> map) {
            state.labelStatesMap = map;
        }
    };
    private Map<Long, NodeState.Mutable> nodeStatesMap;
    private static final NodeState.Defaults NODE_STATE = new NodeState.Defaults(){

        @Override
        Map<Long, NodeState.Mutable> getMap(TxState state) {
            return state.nodeStatesMap;
        }

        @Override
        void setMap(TxState state, Map<Long, NodeState.Mutable> map) {
            state.nodeStatesMap = map;
        }
    };
    private Map<Long, RelationshipState.Mutable> relationshipStatesMap;
    private static final RelationshipState.Defaults RELATIONSHIP_STATE = new RelationshipState.Defaults(){

        @Override
        Map<Long, RelationshipState.Mutable> getMap(TxState state) {
            return state.relationshipStatesMap;
        }

        @Override
        void setMap(TxState state, Map<Long, RelationshipState.Mutable> map) {
            state.relationshipStatesMap = map;
        }
    };
    private Map<Integer, String> createdLabelTokens;
    private Map<Integer, String> createdPropertyKeyTokens;
    private Map<Integer, String> createdRelationshipTypeTokens;
    private GraphState graphState;
    private DiffSets<IndexDescriptor> indexChanges;
    private DiffSets<IndexDescriptor> constraintIndexChanges;
    private DiffSets<UniquenessConstraint> constraintsChanges;
    private PropertyChanges propertyChangesForNodes;
    private DiffSets<Long> nodes;
    private DiffSets<Long> relationships;
    private final Set<Long> nodesDeletedInTx = new HashSet<Long>();
    private final Set<Long> relationshipsDeletedInTx = new HashSet<Long>();
    private Map<UniquenessConstraint, Long> createdConstraintIndexesByConstraint;
    private Map<String, Map<String, String>> createdNodeLegacyIndexes;
    private Map<String, Map<String, String>> createdRelationshipLegacyIndexes;
    private PrimitiveIntObjectMap<Map<DefinedProperty, DiffSets<Long>>> indexUpdates;
    private boolean hasChanges;

    @Override
    public void accept(TxStateVisitor visitor) {
        if (this.nodes != null) {
            this.nodes.accept(TxState.createdNodesVisitor(visitor));
        }
        if (this.relationships != null) {
            this.relationships.accept(TxState.createdRelationshipsVisitor(this, visitor));
            this.relationships.accept(TxState.deletedRelationshipsVisitor(visitor));
        }
        if (this.nodes != null) {
            this.nodes.accept(TxState.deletedNodesVisitor(visitor));
        }
        for (NodeState nodeState : this.modifiedNodes()) {
            nodeState.accept(TxState.nodeVisitor(visitor));
        }
        for (RelationshipState relationshipState : this.modifiedRelationships()) {
            relationshipState.accept(TxState.relVisitor(visitor));
        }
        if (this.graphState != null) {
            this.graphState.accept(TxState.graphPropertyVisitor(visitor));
        }
        if (this.indexChanges != null) {
            this.indexChanges.accept(TxState.indexVisitor(visitor, false));
        }
        if (this.constraintIndexChanges != null) {
            this.constraintIndexChanges.accept(TxState.indexVisitor(visitor, true));
        }
        if (this.constraintsChanges != null) {
            this.constraintsChanges.accept(TxState.constraintsVisitor(visitor));
        }
        if (this.createdLabelTokens != null) {
            for (Map.Entry entry : this.createdLabelTokens.entrySet()) {
                visitor.visitCreatedLabelToken((String)entry.getValue(), (Integer)entry.getKey());
            }
        }
        if (this.createdPropertyKeyTokens != null) {
            for (Map.Entry entry : this.createdPropertyKeyTokens.entrySet()) {
                visitor.visitCreatedPropertyKeyToken((String)entry.getValue(), (Integer)entry.getKey());
            }
        }
        if (this.createdRelationshipTypeTokens != null) {
            for (Map.Entry entry : this.createdRelationshipTypeTokens.entrySet()) {
                visitor.visitCreatedRelationshipTypeToken((String)entry.getValue(), (Integer)entry.getKey());
            }
        }
        if (this.createdNodeLegacyIndexes != null) {
            for (Map.Entry entry : this.createdNodeLegacyIndexes.entrySet()) {
                visitor.visitCreatedNodeLegacyIndex((String)entry.getKey(), (Map)entry.getValue());
            }
        }
        if (this.createdRelationshipLegacyIndexes != null) {
            for (Map.Entry entry : this.createdRelationshipLegacyIndexes.entrySet()) {
                visitor.visitCreatedRelationshipLegacyIndex((String)entry.getKey(), (Map)entry.getValue());
            }
        }
    }

    private static DiffSetsVisitor<Long> deletedNodesVisitor(final TxStateVisitor visitor) {
        return new DiffSetsVisitor.Adapter<Long>(){

            @Override
            public void visitRemoved(Long element) {
                visitor.visitDeletedNode(element);
            }
        };
    }

    private static DiffSetsVisitor<Long> createdNodesVisitor(final TxStateVisitor visitor) {
        return new DiffSetsVisitor.Adapter<Long>(){

            @Override
            public void visitAdded(Long element) {
                visitor.visitCreatedNode(element);
            }
        };
    }

    private static DiffSetsVisitor<Long> deletedRelationshipsVisitor(final TxStateVisitor visitor) {
        return new DiffSetsVisitor.Adapter<Long>(){

            @Override
            public void visitRemoved(Long id) {
                visitor.visitDeletedRelationship(id);
            }
        };
    }

    private static DiffSetsVisitor<Long> createdRelationshipsVisitor(ReadableTxState tx, final TxStateVisitor visitor) {
        return new RelationshipChangeVisitorAdapter(tx){

            @Override
            protected void visitAddedRelationship(long relationshipId, int type, long startNode, long endNode) {
                visitor.visitCreatedRelationship(relationshipId, type, startNode, endNode);
            }
        };
    }

    private static DiffSetsVisitor<UniquenessConstraint> constraintsVisitor(final TxStateVisitor visitor) {
        return new DiffSetsVisitor<UniquenessConstraint>(){

            @Override
            public void visitAdded(UniquenessConstraint element) {
                visitor.visitAddedConstraint(element);
            }

            @Override
            public void visitRemoved(UniquenessConstraint element) {
                visitor.visitRemovedConstraint(element);
            }
        };
    }

    private static DiffSetsVisitor<IndexDescriptor> indexVisitor(final TxStateVisitor visitor, final boolean forConstraint) {
        return new DiffSetsVisitor<IndexDescriptor>(){

            @Override
            public void visitAdded(IndexDescriptor element) {
                visitor.visitAddedIndex(element, forConstraint);
            }

            @Override
            public void visitRemoved(IndexDescriptor element) {
                visitor.visitRemovedIndex(element, forConstraint);
            }
        };
    }

    private static NodeState.Visitor nodeVisitor(final TxStateVisitor visitor) {
        return new NodeState.Visitor(){

            @Override
            public void visitLabelChanges(long nodeId, Set<Integer> added, Set<Integer> removed) {
                visitor.visitNodeLabelChanges(nodeId, added, removed);
            }

            @Override
            public void visitPropertyChanges(long entityId, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
                visitor.visitNodePropertyChanges(entityId, added, changed, removed);
            }

            @Override
            public void visitRelationshipChanges(long nodeId, RelationshipChangesForNode added, RelationshipChangesForNode removed) {
                visitor.visitNodeRelationshipChanges(nodeId, added, removed);
            }
        };
    }

    private static PropertyContainerState.Visitor relVisitor(final TxStateVisitor visitor) {
        return new PropertyContainerState.Visitor(){

            @Override
            public void visitPropertyChanges(long entityId, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
                visitor.visitRelPropertyChanges(entityId, added, changed, removed);
            }
        };
    }

    private static PropertyContainerState.Visitor graphPropertyVisitor(final TxStateVisitor visitor) {
        return new PropertyContainerState.Visitor(){

            @Override
            public void visitPropertyChanges(long entityId, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
                visitor.visitGraphPropertyChanges(added, changed, removed);
            }
        };
    }

    @Override
    public boolean hasChanges() {
        return this.hasChanges;
    }

    @Override
    public Iterable<NodeState> modifiedNodes() {
        return NODE_STATE.values(this);
    }

    private DiffSets<Long> getOrCreateLabelStateNodeDiffSets(int labelId) {
        return ((LabelState.Mutable)LABEL_STATE.getOrCreate(this, labelId)).getOrCreateNodeDiffSets();
    }

    @Override
    public ReadableDiffSets<Integer> nodeStateLabelDiffSets(long nodeId) {
        return ((NodeState)NODE_STATE.get(this, nodeId)).labelDiffSets();
    }

    private DiffSets<Integer> getOrCreateNodeStateLabelDiffSets(long nodeId) {
        return this.getOrCreateNodeState(nodeId).getOrCreateLabelDiffSets();
    }

    @Override
    public Iterator<DefinedProperty> augmentNodeProperties(long nodeId, Iterator<DefinedProperty> original) {
        return ((NodeState)NODE_STATE.get(this, nodeId)).augmentProperties(original);
    }

    @Override
    public Iterator<DefinedProperty> augmentRelationshipProperties(long relId, Iterator<DefinedProperty> original) {
        return ((RelationshipState)RELATIONSHIP_STATE.get(this, relId)).augmentProperties(original);
    }

    @Override
    public Iterator<DefinedProperty> augmentGraphProperties(Iterator<DefinedProperty> original) {
        if (this.graphState != null) {
            return this.graphState.augmentProperties(original);
        }
        return original;
    }

    @Override
    public Iterator<DefinedProperty> addedAndChangedNodeProperties(long nodeId) {
        return ((NodeState)NODE_STATE.get(this, nodeId)).addedAndChangedProperties();
    }

    @Override
    public Iterator<DefinedProperty> addedAndChangedRelationshipProperties(long relId) {
        return ((RelationshipState)RELATIONSHIP_STATE.get(this, relId)).addedAndChangedProperties();
    }

    @Override
    public boolean nodeIsAddedInThisTx(long nodeId) {
        return this.nodes != null && this.nodes.isAdded(nodeId);
    }

    @Override
    public boolean relationshipIsAddedInThisTx(long relationshipId) {
        return this.relationships != null && this.relationships.isAdded(relationshipId);
    }

    @Override
    public void nodeDoCreate(long id) {
        this.nodes().add(id);
        this.hasChanges = true;
    }

    @Override
    public void nodeDoDelete(long nodeId) {
        NodeState.Mutable nodeState;
        if (this.nodes().remove(nodeId)) {
            this.nodesDeletedInTx.add(nodeId);
        }
        if (this.nodeStatesMap != null && (nodeState = this.nodeStatesMap.remove(nodeId)) != null) {
            ReadableDiffSets<Integer> diff = nodeState.labelDiffSets();
            for (Integer label : diff.getAdded()) {
                this.getOrCreateLabelStateNodeDiffSets(label).remove(nodeId);
            }
            nodeState.clearIndexDiffs(nodeId);
            nodeState.clear();
        }
        this.hasChanges = true;
    }

    @Override
    public void relationshipDoCreate(long id, int relationshipTypeId, long startNodeId, long endNodeId) {
        this.relationships().add(id);
        if (startNodeId == endNodeId) {
            this.getOrCreateNodeState(startNodeId).addRelationship(id, relationshipTypeId, Direction.BOTH);
        } else {
            this.getOrCreateNodeState(startNodeId).addRelationship(id, relationshipTypeId, Direction.OUTGOING);
            this.getOrCreateNodeState(endNodeId).addRelationship(id, relationshipTypeId, Direction.INCOMING);
        }
        this.getOrCreateRelationshipState(id).setMetaData(startNodeId, endNodeId, relationshipTypeId);
        this.hasChanges = true;
    }

    @Override
    public boolean nodeIsDeletedInThisTx(long nodeId) {
        return this.addedAndRemovedNodes().isRemoved(nodeId) || this.nodesDeletedInTx.contains(nodeId);
    }

    @Override
    public boolean nodeModifiedInThisTx(long nodeId) {
        return this.nodeIsAddedInThisTx(nodeId) || this.nodeIsDeletedInThisTx(nodeId) || this.hasNodeState(nodeId);
    }

    @Override
    public void relationshipDoDelete(long id, int type, long startNodeId, long endNodeId) {
        RelationshipState.Mutable removed;
        if (this.relationships().remove(id)) {
            this.relationshipsDeletedInTx.add(id);
        }
        if (startNodeId == endNodeId) {
            this.getOrCreateNodeState(startNodeId).removeRelationship(id, type, Direction.BOTH);
        } else {
            this.getOrCreateNodeState(startNodeId).removeRelationship(id, type, Direction.OUTGOING);
            this.getOrCreateNodeState(endNodeId).removeRelationship(id, type, Direction.INCOMING);
        }
        if (this.relationshipStatesMap != null && (removed = this.relationshipStatesMap.remove(id)) != null) {
            removed.clear();
        }
        this.hasChanges = true;
    }

    @Override
    public void relationshipDoDeleteAddedInThisTx(long relationshipId) {
        ((RelationshipState)RELATIONSHIP_STATE.get(this, relationshipId)).accept(new RelationshipVisitor<RuntimeException>(){

            @Override
            public void visit(long relId, int type, long startNode, long endNode) {
                TxState.this.relationshipDoDelete(relId, type, startNode, endNode);
            }
        });
    }

    @Override
    public boolean relationshipIsDeletedInThisTx(long relationshipId) {
        return this.addedAndRemovedRelationships().isRemoved(relationshipId) || this.relationshipsDeletedInTx.contains(relationshipId);
    }

    @Override
    public void nodeDoReplaceProperty(long nodeId, Property replacedProperty, DefinedProperty newProperty) {
        if (replacedProperty.isDefined()) {
            this.getOrCreateNodeState(nodeId).changeProperty(newProperty);
            this.nodePropertyChanges().changeProperty(nodeId, replacedProperty.propertyKeyId(), ((DefinedProperty)replacedProperty).value(), newProperty.value());
        } else {
            NodeState.Mutable nodeState = this.getOrCreateNodeState(nodeId);
            nodeState.addProperty(newProperty);
            this.nodePropertyChanges().addProperty(nodeId, newProperty.propertyKeyId(), newProperty.value());
        }
        this.hasChanges = true;
    }

    @Override
    public void relationshipDoReplaceProperty(long relationshipId, Property replacedProperty, DefinedProperty newProperty) {
        if (replacedProperty.isDefined()) {
            this.getOrCreateRelationshipState(relationshipId).changeProperty(newProperty);
        } else {
            this.getOrCreateRelationshipState(relationshipId).addProperty(newProperty);
        }
        this.hasChanges = true;
    }

    @Override
    public void graphDoReplaceProperty(Property replacedProperty, DefinedProperty newProperty) {
        if (replacedProperty.isDefined()) {
            this.getOrCreateGraphState().changeProperty(newProperty);
        } else {
            this.getOrCreateGraphState().addProperty(newProperty);
        }
        this.hasChanges = true;
    }

    @Override
    public void nodeDoRemoveProperty(long nodeId, DefinedProperty removedProperty) {
        this.getOrCreateNodeState(nodeId).removeProperty(removedProperty);
        this.nodePropertyChanges().removeProperty(nodeId, removedProperty.propertyKeyId(), removedProperty.value());
        this.hasChanges = true;
    }

    @Override
    public void relationshipDoRemoveProperty(long relationshipId, DefinedProperty removedProperty) {
        this.getOrCreateRelationshipState(relationshipId).removeProperty(removedProperty);
        this.hasChanges = true;
    }

    @Override
    public void graphDoRemoveProperty(DefinedProperty removedProperty) {
        this.getOrCreateGraphState().removeProperty(removedProperty);
        this.hasChanges = true;
    }

    @Override
    public void nodeDoAddLabel(int labelId, long nodeId) {
        this.getOrCreateLabelStateNodeDiffSets(labelId).add(nodeId);
        this.getOrCreateNodeStateLabelDiffSets(nodeId).add(labelId);
        this.hasChanges = true;
    }

    @Override
    public void nodeDoRemoveLabel(int labelId, long nodeId) {
        this.getOrCreateLabelStateNodeDiffSets(labelId).remove(nodeId);
        this.getOrCreateNodeStateLabelDiffSets(nodeId).remove(labelId);
        this.hasChanges = true;
    }

    @Override
    public void labelDoCreateForName(String labelName, int id) {
        if (this.createdLabelTokens == null) {
            this.createdLabelTokens = new HashMap<Integer, String>();
        }
        this.createdLabelTokens.put(id, labelName);
        this.hasChanges = true;
    }

    @Override
    public void propertyKeyDoCreateForName(String propertyKeyName, int id) {
        if (this.createdPropertyKeyTokens == null) {
            this.createdPropertyKeyTokens = new HashMap<Integer, String>();
        }
        this.createdPropertyKeyTokens.put(id, propertyKeyName);
        this.hasChanges = true;
    }

    @Override
    public void relationshipTypeDoCreateForName(String labelName, int id) {
        if (this.createdRelationshipTypeTokens == null) {
            this.createdRelationshipTypeTokens = new HashMap<Integer, String>();
        }
        this.createdRelationshipTypeTokens.put(id, labelName);
        this.hasChanges = true;
    }

    @Override
    public UpdateTriState labelState(long nodeId, int labelId) {
        return ((NodeState)NODE_STATE.get(this, nodeId)).labelState(labelId);
    }

    @Override
    public ReadableDiffSets<Long> nodesWithLabelChanged(int labelId) {
        return ((LabelState)LABEL_STATE.get(this, labelId)).nodeDiffSets();
    }

    @Override
    public void indexRuleDoAdd(IndexDescriptor descriptor) {
        DiffSets<IndexDescriptor> diff = this.indexChangesDiffSets();
        if (diff.unRemove(descriptor)) {
            this.getOrCreateLabelState(descriptor.getLabelId()).getOrCreateIndexChanges().unRemove(descriptor);
        } else {
            diff.add(descriptor);
            this.getOrCreateLabelState(descriptor.getLabelId()).getOrCreateIndexChanges().add(descriptor);
        }
        this.hasChanges = true;
    }

    @Override
    public void constraintIndexRuleDoAdd(IndexDescriptor descriptor) {
        this.constraintIndexChangesDiffSets().add(descriptor);
        this.getOrCreateLabelState(descriptor.getLabelId()).getOrCreateConstraintIndexChanges().add(descriptor);
        this.hasChanges = true;
    }

    @Override
    public void indexDoDrop(IndexDescriptor descriptor) {
        this.indexChangesDiffSets().remove(descriptor);
        this.getOrCreateLabelState(descriptor.getLabelId()).getOrCreateIndexChanges().remove(descriptor);
        this.hasChanges = true;
    }

    @Override
    public void constraintIndexDoDrop(IndexDescriptor descriptor) {
        this.constraintIndexChangesDiffSets().remove(descriptor);
        this.getOrCreateLabelState(descriptor.getLabelId()).getOrCreateConstraintIndexChanges().remove(descriptor);
        this.hasChanges = true;
    }

    @Override
    public ReadableDiffSets<IndexDescriptor> indexDiffSetsByLabel(int labelId) {
        return ((LabelState)LABEL_STATE.get(this, labelId)).indexChanges();
    }

    @Override
    public ReadableDiffSets<IndexDescriptor> constraintIndexDiffSetsByLabel(int labelId) {
        return ((LabelState)LABEL_STATE.get(this, labelId)).constraintIndexChanges();
    }

    @Override
    public ReadableDiffSets<IndexDescriptor> indexChanges() {
        return ReadableDiffSets.Empty.ifNull(this.indexChanges);
    }

    private DiffSets<IndexDescriptor> indexChangesDiffSets() {
        if (this.indexChanges == null) {
            this.indexChanges = new DiffSets();
        }
        return this.indexChanges;
    }

    @Override
    public ReadableDiffSets<IndexDescriptor> constraintIndexChanges() {
        return ReadableDiffSets.Empty.ifNull(this.constraintIndexChanges);
    }

    private DiffSets<IndexDescriptor> constraintIndexChangesDiffSets() {
        if (this.constraintIndexChanges == null) {
            this.constraintIndexChanges = new DiffSets();
        }
        return this.constraintIndexChanges;
    }

    @Override
    public ReadableDiffSets<Long> nodesWithChangedProperty(int propertyKeyId, Object value) {
        return this.propertyChangesForNodes != null ? this.propertyChangesForNodes.changesForProperty(propertyKeyId, value) : ReadableDiffSets.Empty.instance();
    }

    @Override
    public ReadableDiffSets<Long> addedAndRemovedNodes() {
        return ReadableDiffSets.Empty.ifNull(this.nodes);
    }

    private DiffSets<Long> nodes() {
        if (this.nodes == null) {
            this.nodes = new DiffSets();
        }
        return this.nodes;
    }

    @Override
    public PrimitiveLongIterator augmentRelationships(long nodeId, Direction direction, PrimitiveLongIterator rels) {
        NodeState state;
        if (this.nodeStatesMap != null && (state = (NodeState)this.nodeStatesMap.get(nodeId)) != null) {
            rels = state.augmentRelationships(direction, rels);
            rels = this.addedAndRemovedRelationships().augmentWithRemovals(rels);
        }
        return rels;
    }

    @Override
    public PrimitiveLongIterator augmentRelationships(long nodeId, Direction direction, int[] types, PrimitiveLongIterator rels) {
        NodeState state;
        if (this.nodeStatesMap != null && (state = (NodeState)this.nodeStatesMap.get(nodeId)) != null) {
            rels = state.augmentRelationships(direction, types, rels);
            rels = this.addedAndRemovedRelationships().augmentWithRemovals(rels);
        }
        return rels;
    }

    @Override
    public PrimitiveLongIterator addedRelationships(long nodeId, int[] types, Direction direction) {
        return ((NodeState)NODE_STATE.get(this, nodeId)).addedRelationships(direction, types);
    }

    @Override
    public int augmentNodeDegree(long nodeId, int degree, Direction direction) {
        return ((NodeState)NODE_STATE.get(this, nodeId)).augmentDegree(direction, degree);
    }

    @Override
    public int augmentNodeDegree(long nodeId, int degree, Direction direction, int typeId) {
        return ((NodeState)NODE_STATE.get(this, nodeId)).augmentDegree(direction, degree, typeId);
    }

    @Override
    public PrimitiveIntIterator nodeRelationshipTypes(long nodeId) {
        return ((NodeState)NODE_STATE.get(this, nodeId)).relationshipTypes();
    }

    @Override
    public ReadableDiffSets<Long> addedAndRemovedRelationships() {
        return ReadableDiffSets.Empty.ifNull(this.relationships);
    }

    private DiffSets<Long> relationships() {
        if (this.relationships == null) {
            this.relationships = new DiffSets();
        }
        return this.relationships;
    }

    @Override
    public Iterable<RelationshipState> modifiedRelationships() {
        return RELATIONSHIP_STATE.values(this);
    }

    private LabelState.Mutable getOrCreateLabelState(int labelId) {
        return (LabelState.Mutable)LABEL_STATE.getOrCreate(this, labelId);
    }

    private NodeState.Mutable getOrCreateNodeState(long nodeId) {
        return (NodeState.Mutable)NODE_STATE.getOrCreate(this, nodeId);
    }

    private RelationshipState.Mutable getOrCreateRelationshipState(long relationshipId) {
        return (RelationshipState.Mutable)RELATIONSHIP_STATE.getOrCreate(this, relationshipId);
    }

    private GraphState getOrCreateGraphState() {
        if (this.graphState == null) {
            this.graphState = new GraphState();
        }
        return this.graphState;
    }

    @Override
    public void constraintDoAdd(UniquenessConstraint constraint, long indexId) {
        this.constraintsChangesDiffSets().add(constraint);
        this.createdConstraintIndexesByConstraint().put(constraint, indexId);
        this.getOrCreateLabelState(constraint.label()).getOrCreateConstraintsChanges().add(constraint);
        this.hasChanges = true;
    }

    @Override
    public ReadableDiffSets<UniquenessConstraint> constraintsChangesForLabelAndProperty(int labelId, final int propertyKey) {
        return ((LabelState)LABEL_STATE.get(this, labelId)).constraintsChanges().filterAdded(new Predicate<UniquenessConstraint>(){

            @Override
            public boolean accept(UniquenessConstraint item) {
                return item.propertyKeyId() == propertyKey;
            }
        });
    }

    @Override
    public ReadableDiffSets<UniquenessConstraint> constraintsChangesForLabel(int labelId) {
        return ((LabelState)LABEL_STATE.get(this, labelId)).constraintsChanges();
    }

    @Override
    public ReadableDiffSets<UniquenessConstraint> constraintsChanges() {
        return ReadableDiffSets.Empty.ifNull(this.constraintsChanges);
    }

    private DiffSets<UniquenessConstraint> constraintsChangesDiffSets() {
        if (this.constraintsChanges == null) {
            this.constraintsChanges = new DiffSets();
        }
        return this.constraintsChanges;
    }

    @Override
    public void constraintDoDrop(UniquenessConstraint constraint) {
        this.constraintsChangesDiffSets().remove(constraint);
        this.constraintIndexDoDrop(new IndexDescriptor(constraint.label(), constraint.propertyKeyId()));
        this.getOrCreateLabelState(constraint.label()).getOrCreateConstraintsChanges().remove(constraint);
        this.hasChanges = true;
    }

    @Override
    public boolean constraintDoUnRemove(UniquenessConstraint constraint) {
        if (this.constraintsChangesDiffSets().unRemove(constraint)) {
            this.getOrCreateLabelState(constraint.label()).getOrCreateConstraintsChanges().unRemove(constraint);
            return true;
        }
        return false;
    }

    @Override
    public boolean constraintIndexDoUnRemove(IndexDescriptor index) {
        if (this.constraintIndexChangesDiffSets().unRemove(index)) {
            ((LabelState.Mutable)LABEL_STATE.getOrCreate(this, index.getLabelId())).getOrCreateConstraintIndexChanges().unRemove(index);
            return true;
        }
        return false;
    }

    @Override
    public Iterable<IndexDescriptor> constraintIndexesCreatedInTx() {
        if (this.createdConstraintIndexesByConstraint != null && !this.createdConstraintIndexesByConstraint.isEmpty()) {
            return Iterables.map(new Function<UniquenessConstraint, IndexDescriptor>(){

                public IndexDescriptor apply(UniquenessConstraint constraint) {
                    return new IndexDescriptor(constraint.label(), constraint.propertyKeyId());
                }
            }, this.createdConstraintIndexesByConstraint.keySet());
        }
        return Iterables.empty();
    }

    @Override
    public Long indexCreatedForConstraint(UniquenessConstraint constraint) {
        return this.createdConstraintIndexesByConstraint == null ? null : this.createdConstraintIndexesByConstraint.get(constraint);
    }

    @Override
    public ReadableDiffSets<Long> indexUpdates(IndexDescriptor descriptor, Object value) {
        return ReadableDiffSets.Empty.ifNull(this.getIndexUpdates(descriptor.getLabelId(), false, Property.property(descriptor.getPropertyKeyId(), value)));
    }

    @Override
    public void indexDoUpdateProperty(IndexDescriptor descriptor, long nodeId, DefinedProperty propertyBefore, DefinedProperty propertyAfter) {
        DiffSets<Long> after;
        DiffSets<Long> before = this.getIndexUpdates(descriptor.getLabelId(), true, propertyBefore);
        if (before != null) {
            before.remove(nodeId);
            if (before.getRemoved().contains(nodeId)) {
                this.getOrCreateNodeState(nodeId).addIndexDiff(before);
            } else {
                this.getOrCreateNodeState(nodeId).removeIndexDiff(before);
            }
        }
        if ((after = this.getIndexUpdates(descriptor.getLabelId(), true, propertyAfter)) != null) {
            after.add(nodeId);
            if (after.getAdded().contains(nodeId)) {
                this.getOrCreateNodeState(nodeId).addIndexDiff(after);
            } else {
                this.getOrCreateNodeState(nodeId).removeIndexDiff(after);
            }
        }
    }

    private DiffSets<Long> getIndexUpdates(int label, boolean create, DefinedProperty property) {
        DiffSets diffs;
        HashMap updates;
        if (property == null) {
            return null;
        }
        if (this.indexUpdates == null) {
            if (!create) {
                return null;
            }
            this.indexUpdates = Primitive.intObjectMap();
        }
        if ((updates = (HashMap)this.indexUpdates.get(label)) == null) {
            if (!create) {
                return null;
            }
            updates = new HashMap();
            this.indexUpdates.put(label, updates);
        }
        if ((diffs = (DiffSets)updates.get(property)) == null && create) {
            diffs = new DiffSets();
            updates.put(property, diffs);
        }
        return diffs;
    }

    private Map<UniquenessConstraint, Long> createdConstraintIndexesByConstraint() {
        if (this.createdConstraintIndexesByConstraint == null) {
            this.createdConstraintIndexesByConstraint = new HashMap<UniquenessConstraint, Long>();
        }
        return this.createdConstraintIndexesByConstraint;
    }

    private boolean hasNodeState(long nodeId) {
        return this.nodeStatesMap != null && this.nodeStatesMap.containsKey(nodeId);
    }

    private PropertyChanges nodePropertyChanges() {
        return this.propertyChangesForNodes == null ? (this.propertyChangesForNodes = new PropertyChanges()) : this.propertyChangesForNodes;
    }

    @Override
    public PrimitiveLongIterator augmentNodesGetAll(PrimitiveLongIterator committed) {
        return this.addedAndRemovedNodes().augment(committed);
    }

    @Override
    public PrimitiveLongIterator augmentRelationshipsGetAll(PrimitiveLongIterator committed) {
        return this.addedAndRemovedRelationships().augment(committed);
    }

    @Override
    public <EX extends Exception> boolean relationshipVisit(long relId, RelationshipVisitor<EX> visitor) throws EX {
        return ((RelationshipState)RELATIONSHIP_STATE.get(this, relId)).accept(visitor);
    }

    @Override
    public void nodeLegacyIndexDoCreate(String indexName, Map<String, String> customConfig) {
        assert (customConfig != null);
        if (this.createdNodeLegacyIndexes == null) {
            this.createdNodeLegacyIndexes = new HashMap<String, Map<String, String>>();
        }
        this.createdNodeLegacyIndexes.put(indexName, customConfig);
        this.hasChanges = true;
    }

    @Override
    public void relationshipLegacyIndexDoCreate(String indexName, Map<String, String> customConfig) {
        assert (customConfig != null);
        if (this.createdRelationshipLegacyIndexes == null) {
            this.createdRelationshipLegacyIndexes = new HashMap<String, Map<String, String>>();
        }
        this.createdRelationshipLegacyIndexes.put(indexName, customConfig);
        this.hasChanges = true;
    }
}

