/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.graphdb.factory.SettingsResourceBundle;
import org.neo4j.helpers.Triplet;
import org.neo4j.kernel.configuration.AsciiDocListGenerator;

public class ConfigAsciiDocGenerator {
    private static final Pattern CONFIG_SETTING_PATTERN = Pattern.compile("[a-z0-9]+((\\.|_)[a-z0-9]+)+");

    public String generateDocsFor(Class<? extends SettingsResourceBundle> settingsResource) {
        return this.generateDocsFor(settingsResource.getName());
    }

    public String generateDocsFor(String settingsResource) {
        SettingsResourceBundle bundle;
        try {
            bundle = new SettingsResourceBundle(Class.forName(settingsResource));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Couldn't load settings class: ", e);
        }
        System.out.println("Generating docs for: " + settingsResource);
        String settingsResourceId = "config-" + settingsResource;
        String bundleDescription = "List of configuration settings";
        if (bundle.containsKey("description")) {
            bundleDescription = bundle.getString("description");
        }
        StringBuilder details = new StringBuilder();
        ArrayList<Triplet<String, String, String>> beanList = new ArrayList<Triplet<String, String, String>>();
        ArrayList<Triplet<String, String, String>> deprecatedBeansList = new ArrayList<Triplet<String, String, String>>();
        AsciiDocListGenerator listGenerator = new AsciiDocListGenerator(settingsResourceId, bundleDescription, true);
        AsciiDocListGenerator deprecatedBeanslistGenerator = new AsciiDocListGenerator(settingsResourceId + "-deprecated", "Deprecated settings", true);
        ArrayList<String> keys = new ArrayList<String>(((ResourceBundle)bundle).keySet());
        Collections.sort(keys);
        for (String property : keys) {
            String mandatorykey;
            String defaultValue;
            if (!property.endsWith(".description")) continue;
            String name = property.substring(0, property.lastIndexOf("."));
            String monospacedName = "+" + name + "+";
            String internalKey = name + ".internal";
            if (bundle.containsKey(internalKey)) continue;
            String id = "config_" + name;
            details.append("[[").append(id).append("]]\n").append('.').append(name).append('\n').append("[cols=\"<1h,<4\"]\n").append("|===\n");
            String defaultKey = name + ".default";
            String description = this.linkifyConfigSettings(bundle.getString(property));
            details.append("|Description a|");
            this.addWithDotAtEndAsNeeeded(details, description);
            String validationKey = name + ".validationmessage";
            if (bundle.containsKey(validationKey)) {
                String validation = bundle.getString(validationKey);
                validation = validation.replace(name, monospacedName);
                details.append("|Valid values a|");
                this.addWithDotAtEndAsNeeeded(details, this.linkifyConfigSettings(validation, name));
            }
            if (bundle.containsKey(defaultKey) && !(defaultValue = bundle.getString(defaultKey)).equals("__DEFAULT__")) {
                details.append("|Default value m|").append(defaultValue).append('\n');
            }
            if (bundle.containsKey(mandatorykey = name + ".mandatory")) {
                details.append("|Mandatory a|");
                this.addWithDotAtEndAsNeeeded(details, bundle.getString(mandatorykey).replace(name, monospacedName));
            }
            Triplet<String, String, String> beanSummary = Triplet.of(id, name, description);
            String deprecatedKey = name + ".deprecated";
            String obsoletedKey = name + ".obsoleted";
            if (bundle.containsKey(deprecatedKey) || bundle.containsKey(obsoletedKey)) {
                details.append("|Deprecated a|");
                if (bundle.containsKey(obsoletedKey)) {
                    this.addWithDotAtEndAsNeeeded(details, this.linkifyConfigSettings(bundle.getString(obsoletedKey)));
                } else {
                    this.addWithDotAtEndAsNeeeded(details, this.linkifyConfigSettings(bundle.getString(deprecatedKey)));
                }
                deprecatedBeansList.add(beanSummary);
            } else {
                beanList.add(beanSummary);
            }
            details.append("|===\n\n");
        }
        return listGenerator.generateListAndTableCombo(beanList) + (deprecatedBeansList.isEmpty() ? "" : deprecatedBeanslistGenerator.generateListAndTableCombo(deprecatedBeansList)) + details.toString();
    }

    private void addWithDotAtEndAsNeeeded(StringBuilder sb, String message) {
        sb.append(message);
        if (!message.endsWith(".") && !message.endsWith(". ")) {
            sb.append('.');
        }
        sb.append('\n');
    }

    private String linkifyConfigSettings(String text, String nameToNotLink) {
        Matcher matcher = CONFIG_SETTING_PATTERN.matcher(text);
        StringBuffer result = new StringBuffer(256);
        while (matcher.find()) {
            String match = matcher.group();
            match = match.endsWith(".log") ? "_" + match + "_" : (match.equals(nameToNotLink) ? "`" + match + "`" : this.makeConfigXref(match));
            matcher.appendReplacement(result, match);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private String linkifyConfigSettings(String text) {
        return this.linkifyConfigSettings(text, null);
    }

    private String makeConfigXref(String settingName) {
        return "+<<config_" + settingName + "," + settingName + ">>+";
    }
}

