/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.neo4j.function.IOFunction;
import org.neo4j.function.RawFunction;
import org.neo4j.helpers.Format;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputNodeCacher;
import org.neo4j.unsafe.impl.batchimport.input.InputNodeReader;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationshipCacher;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationshipReader;
import org.neo4j.unsafe.impl.batchimport.input.Receiver;

public class InputCache
implements Closeable {
    private static final String HEADER = "-header";
    private static final String NODES = "nodes";
    private static final String RELATIONSHIPS = "relationships";
    private static final String NODES_HEADER = "nodes-header";
    private static final String RELATIONSHIPS_HEADER = "relationships-header";
    static final byte SAME_GROUP = 0;
    static final byte NEW_GROUP = 1;
    static final byte TOKEN = 1;
    static final short HAS_FIRST_PROPERTY_ID = -1;
    static final byte HAS_LABEL_FIELD = 3;
    static final byte LABEL_REMOVAL = 1;
    static final byte LABEL_ADDITION = 2;
    static final byte END_OF_LABEL_CHANGES = 0;
    static final byte SPECIFIC_ID = 1;
    static final byte UNSPECIFIED_ID = 0;
    static final byte HAS_TYPE_ID = 2;
    static final byte SAME_TYPE = 0;
    static final byte NEW_TYPE = 1;
    static final byte END_OF_HEADER = 0;
    static final short END_OF_ENTITIES = -2;
    private final FileSystemAbstraction fs;
    private final File cacheDirectory;
    private final int bufferSize;

    public InputCache(FileSystemAbstraction fs, File cacheDirectory) {
        this(fs, cacheDirectory, 512 * Format.KB);
    }

    public InputCache(FileSystemAbstraction fs, File cacheDirectory, int bufferSize) {
        this.fs = fs;
        this.cacheDirectory = cacheDirectory;
        this.bufferSize = bufferSize;
    }

    public Receiver<InputNode[], IOException> cacheNodes() throws IOException {
        return new InputNodeCacher(this.channel(NODES, "rw"), this.channel(NODES_HEADER, "rw"), this.bufferSize);
    }

    public Receiver<InputRelationship[], IOException> cacheRelationships() throws IOException {
        return new InputRelationshipCacher(this.channel(RELATIONSHIPS, "rw"), this.channel(RELATIONSHIPS_HEADER, "rw"), this.bufferSize);
    }

    private StoreChannel channel(String type, String mode) throws IOException {
        return this.fs.open(this.file(type), mode);
    }

    private File file(String type) {
        return new File(this.cacheDirectory, "input-" + type);
    }

    public InputIterable<InputNode> nodes() {
        return this.entities((RawFunction)new IOFunction<Void, InputIterator<InputNode>>(){

            public InputIterator<InputNode> apply(Void ignore) throws IOException {
                return new InputNodeReader(InputCache.this.channel(InputCache.NODES, "r"), InputCache.this.channel(InputCache.NODES_HEADER, "r"), InputCache.this.bufferSize);
            }
        });
    }

    public InputIterable<InputRelationship> relationships() {
        return this.entities((RawFunction)new IOFunction<Void, InputIterator<InputRelationship>>(){

            public InputIterator<InputRelationship> apply(Void ignore) throws IOException {
                return new InputRelationshipReader(InputCache.this.channel(InputCache.RELATIONSHIPS, "r"), InputCache.this.channel(InputCache.RELATIONSHIPS_HEADER, "r"), InputCache.this.bufferSize);
            }
        });
    }

    private <T extends InputEntity> InputIterable<T> entities(final RawFunction<Void, InputIterator<T>, IOException> factory) {
        return new InputIterable<T>(){

            @Override
            public InputIterator<T> iterator() {
                try {
                    return (InputIterator)factory.apply(null);
                }
                catch (IOException e) {
                    throw new InputException("Unable to read cached relationship", e);
                }
            }

            @Override
            public boolean supportsMultiplePasses() {
                return true;
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.fs.deleteFile(this.file(NODES));
        this.fs.deleteFile(this.file(RELATIONSHIPS));
        this.fs.deleteFile(this.file(NODES_HEADER));
        this.fs.deleteFile(this.file(RELATIONSHIPS_HEADER));
    }
}

