/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.neo4j.collection.pool.LinkedQueuePool;
import org.neo4j.function.Factory;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.kernel.impl.store.AbstractRecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.util.statistics.IntCounter;

public class DirectRecordAccess<KEY extends Comparable<KEY>, RECORD extends AbstractBaseRecord, ADDITIONAL>
implements RecordAccess<KEY, RECORD, ADDITIONAL> {
    private final AbstractRecordStore<RECORD> store;
    private final RecordAccess.Loader<KEY, RECORD, ADDITIONAL> loader;
    private final SortedMap<KEY, DirectRecordProxy> batch = new TreeMap<KEY, DirectRecordProxy>(new Comparator<KEY>(){

        @Override
        public int compare(KEY o1, KEY o2) {
            return -o1.compareTo(o2);
        }
    });
    private final LinkedQueuePool<DirectRecordProxy> proxyFlyweightPool;
    private final IntCounter changeCounter = new IntCounter();

    public DirectRecordAccess(AbstractRecordStore<RECORD> store, RecordAccess.Loader<KEY, RECORD, ADDITIONAL> loader) {
        this.store = store;
        this.loader = loader;
        this.proxyFlyweightPool = new LinkedQueuePool(100, (Factory)new Factory<DirectRecordProxy>(){

            public DirectRecordProxy newInstance() {
                return new DirectRecordProxy();
            }
        });
    }

    @Override
    public RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> getOrLoad(KEY key, ADDITIONAL additionalData) {
        DirectRecordProxy loaded = (DirectRecordProxy)this.batch.get(key);
        if (loaded != null) {
            return loaded;
        }
        return this.putInBatch(key, this.proxy(key, (AbstractBaseRecord)this.loader.load(key, additionalData), additionalData, false));
    }

    private RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> putInBatch(KEY key, DirectRecordProxy proxy) {
        DirectRecordProxy previous = this.batch.put(key, proxy);
        assert (previous == null);
        return proxy;
    }

    @Override
    public RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> create(KEY key, ADDITIONAL additionalData) {
        return this.putInBatch(key, this.proxy(key, (AbstractBaseRecord)this.loader.newUnused(key, additionalData), additionalData, true));
    }

    @Override
    public RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> getIfLoaded(KEY key) {
        return (RecordAccess.RecordProxy)this.batch.get(key);
    }

    @Override
    public void setTo(KEY key, RECORD newRecord, ADDITIONAL additionalData) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int changeSize() {
        return this.changeCounter.value();
    }

    @Override
    public Iterable<RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL>> changes() {
        return new IterableWrapper<RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL>, DirectRecordProxy>(this.batch.values()){

            @Override
            protected RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> underlyingObjectToObject(DirectRecordProxy object) {
                return object;
            }
        };
    }

    private DirectRecordProxy proxy(KEY key, RECORD record, ADDITIONAL additionalData, boolean created) {
        DirectRecordProxy result = (DirectRecordProxy)this.proxyFlyweightPool.acquire();
        result.bind(key, record, additionalData, created);
        return result;
    }

    @Override
    public void close() {
        this.commit();
    }

    public void commit() {
        if (this.changeCounter.value() == 0) {
            return;
        }
        for (DirectRecordProxy proxy : this.batch.values()) {
            proxy.store();
            this.proxyFlyweightPool.release((Object)proxy);
        }
        this.changeCounter.clear();
        this.batch.clear();
    }

    private class DirectRecordProxy
    implements RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> {
        private KEY key;
        private RECORD record;
        private ADDITIONAL additionalData;
        private boolean changed;

        private DirectRecordProxy() {
        }

        public void bind(KEY key, RECORD record, ADDITIONAL additionalData, boolean created) {
            this.changed = false;
            this.key = key;
            this.record = record;
            this.additionalData = additionalData;
            if (created) {
                this.prepareChange();
            }
        }

        @Override
        public KEY getKey() {
            return this.key;
        }

        @Override
        public RECORD forChangingLinkage() {
            this.prepareChange();
            return this.record;
        }

        private void prepareChange() {
            if (!this.changed) {
                this.changed = true;
                DirectRecordAccess.this.changeCounter.increment();
            }
        }

        @Override
        public RECORD forChangingData() {
            DirectRecordAccess.this.loader.ensureHeavy(this.record);
            this.prepareChange();
            return this.record;
        }

        @Override
        public RECORD forReadingLinkage() {
            return this.record;
        }

        @Override
        public RECORD forReadingData() {
            DirectRecordAccess.this.loader.ensureHeavy(this.record);
            return this.record;
        }

        @Override
        public ADDITIONAL getAdditionalData() {
            return this.additionalData;
        }

        @Override
        public RECORD getBefore() {
            return (AbstractBaseRecord)DirectRecordAccess.this.loader.load(this.key, this.additionalData);
        }

        public String toString() {
            return this.record.toString();
        }

        public void store() {
            if (this.changed) {
                DirectRecordAccess.this.store.updateRecord(this.record);
            }
        }

        @Override
        public boolean isChanged() {
            return this.changed;
        }
    }
}

