/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.api.CommandApplierFacade;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.CountsStoreApplier;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.counts.DumpCountsStore;
import org.neo4j.kernel.impl.store.counts.TransactionStream;
import org.neo4j.kernel.impl.store.counts.keys.IndexSampleKey;
import org.neo4j.kernel.impl.store.counts.keys.IndexStatisticsKey;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.IOCursor;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.monitoring.Monitors;

public class RecountFromTransactions {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws Exception {
        TransactionStream transactions;
        File path;
        DefaultFileSystemAbstraction fs;
        if (args.length != 1) {
            System.err.println("Expecting exactly one argument describing the path to the store");
            System.exit(1);
        }
        if (!(fs = new DefaultFileSystemAbstraction()).isDirectory(path = new File(args[0]))) {
            System.err.println(args[0] + " is not a directory.");
            System.exit(1);
        }
        if ((transactions = new TransactionStream((FileSystemAbstraction)fs, path)).firstTransactionId() != 1L || !transactions.isContiguous()) {
            System.err.println("Transaction stream is not contiguous:" + transactions.rangeString("\n\t"));
            System.exit(1);
        }
        File nodeStore = new File(path, "recount-from-tx");
        try (PageCache pages = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs);){
            StoreFactory factory = new StoreFactory((FileSystemAbstraction)fs, path, pages, StringLogger.DEV_NULL, new Monitors());
            CountsRecordState counts = RecountFromTransactions.rebuildCounts(transactions);
            DumpCountsStore dump = new DumpCountsStore(System.out, factory);
            System.out.println("Expected counts:");
            counts.accept(dump);
            RecountFromTransactions.verifyCounts(factory, counts, dump);
        }
        finally {
            RecountFromTransactions.deleteStore((FileSystemAbstraction)fs, nodeStore);
            RecountFromTransactions.deleteStore((FileSystemAbstraction)fs, RecountFromTransactions.nodeLabelStore(nodeStore));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CountsRecordState rebuildCounts(TransactionStream transactions) throws IOException {
        CountsRecordState counts = new CountsRecordState();
        try (IOCursor<CommittedTransactionRepresentation> cursor = transactions.cursor();){
            while (cursor.next()) {
                CommandApplierFacade visitor;
                block22: {
                    visitor = new CommandApplierFacade(new CountsStoreApplier(counts));
                    Throwable throwable = null;
                    try {
                        cursor.get().accept(visitor);
                        if (visitor == null) continue;
                        if (throwable == null) break block22;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (visitor == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    visitor.close();
                                    throw throwable3;
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                    throw throwable3;
                                }
                            }
                            visitor.close();
                            throw throwable3;
                        }
                    }
                    try {
                        visitor.close();
                        continue;
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                        continue;
                    }
                }
                visitor.close();
            }
            return counts;
        }
    }

    private static void verifyCounts(StoreFactory factory, CountsRecordState counts, CountsVisitor dump) {
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            CountsTracker tracker = life.add(factory.newCountsStore());
            tracker.accept(dump);
            List<CountsRecordState.Difference> differences = counts.verify(tracker);
            boolean equal = true;
            for (CountsRecordState.Difference difference : differences) {
                if (difference.key() instanceof IndexSampleKey || difference.key() instanceof IndexStatisticsKey) continue;
                if (equal) {
                    System.out.println("Difference in counts:");
                    equal = false;
                }
                System.out.println("\t" + difference);
            }
            if (equal) {
                System.out.println("Counts store has expected data.");
            }
        }
    }

    private static void deleteStore(FileSystemAbstraction fs, File storeFile) {
        fs.deleteFile(storeFile);
        fs.deleteFile(new File(storeFile.getPath() + ".id"));
    }

    private static File nodeLabelStore(File nodeStore) {
        return new File(nodeStore.getPath() + ".labels");
    }
}

