/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;

public class PropertyKeyTokenStore
extends TokenStore<PropertyKeyTokenRecord> {
    public static final String TYPE_DESCRIPTOR = "PropertyIndexStore";
    public static final int RECORD_SIZE = 9;

    public PropertyKeyTokenStore(File fileName, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, DynamicStringStore nameStore, StoreVersionMismatchHandler versionMismatchHandler, Monitors monitors) {
        super(fileName, config, IdType.PROPERTY_KEY_TOKEN, idGeneratorFactory, pageCache, fileSystemAbstraction, stringLogger, nameStore, versionMismatchHandler, monitors);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, PropertyKeyTokenRecord record) throws FAILURE {
        processor.processPropertyKeyToken(this, record);
    }

    @Override
    protected PropertyKeyTokenRecord newRecord(int id) {
        return new PropertyKeyTokenRecord(id);
    }

    @Override
    protected void readRecord(PropertyKeyTokenRecord record, PageCursor cursor) {
        record.setPropertyCount(cursor.getInt());
        record.setNameId(cursor.getInt());
    }

    @Override
    protected void writeRecord(PropertyKeyTokenRecord record, PageCursor cursor) {
        cursor.putInt(record.getPropertyCount());
        cursor.putInt(record.getNameId());
    }

    @Override
    public int getRecordSize() {
        return 9;
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }
}

