/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.api.LegacyIndex;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.legacyindex.LegacyIndexNotFoundKernelException;
import org.neo4j.kernel.api.txstate.LegacyIndexTransactionState;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.transaction.command.Command;

class CachingLegacyIndexTransactionState
implements LegacyIndexTransactionState {
    private Map<String, LegacyIndex> nodeLegacyIndexChanges;
    private Map<String, LegacyIndex> relationshipLegacyIndexChanges;
    private final LegacyIndexTransactionState txState;

    CachingLegacyIndexTransactionState(LegacyIndexTransactionState txState) {
        this.txState = txState;
    }

    @Override
    public void initialize() {
        this.txState.initialize();
        if (this.nodeLegacyIndexChanges != null && !this.nodeLegacyIndexChanges.isEmpty()) {
            this.nodeLegacyIndexChanges.clear();
        }
        if (this.relationshipLegacyIndexChanges != null && !this.relationshipLegacyIndexChanges.isEmpty()) {
            this.relationshipLegacyIndexChanges.clear();
        }
    }

    @Override
    public LegacyIndex nodeChanges(String indexName) throws LegacyIndexNotFoundKernelException {
        LegacyIndex changes;
        if (this.nodeLegacyIndexChanges == null) {
            this.nodeLegacyIndexChanges = new HashMap<String, LegacyIndex>();
        }
        if ((changes = this.nodeLegacyIndexChanges.get(indexName)) == null) {
            changes = this.txState.nodeChanges(indexName);
            this.nodeLegacyIndexChanges.put(indexName, changes);
        }
        return changes;
    }

    @Override
    public LegacyIndex relationshipChanges(String indexName) throws LegacyIndexNotFoundKernelException {
        LegacyIndex changes;
        if (this.relationshipLegacyIndexChanges == null) {
            this.relationshipLegacyIndexChanges = new HashMap<String, LegacyIndex>();
        }
        if ((changes = this.relationshipLegacyIndexChanges.get(indexName)) == null) {
            changes = this.txState.relationshipChanges(indexName);
            this.relationshipLegacyIndexChanges.put(indexName, changes);
        }
        return changes;
    }

    @Override
    public void createIndex(IndexEntityType node, String name, Map<String, String> config) {
        this.txState.createIndex(node, name, config);
    }

    @Override
    public void deleteIndex(IndexEntityType entityType, String indexName) {
        this.txState.deleteIndex(entityType, indexName);
    }

    @Override
    public boolean hasChanges() {
        return this.txState.hasChanges();
    }

    @Override
    public void extractCommands(Collection<Command> target) throws TransactionFailureException {
        this.txState.extractCommands(target);
    }
}

