/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.unsafe.impl.batchimport.store.BatchingIdSequence;

public class BatchingIdGeneratorFactory
implements IdGeneratorFactory {
    private final Map<IdType, IdGenerator> idGenerators = new EnumMap<IdType, IdGenerator>(IdType.class);

    @Override
    public IdGenerator open(FileSystemAbstraction fs, File fileName, int grabSize, IdType idType, long highId) {
        IdGenerator generator = this.idGenerators.get((Object)idType);
        if (generator == null) {
            generator = new BatchingIdGenerator(fs, fileName, highId);
            this.idGenerators.put(idType, generator);
        }
        return generator;
    }

    @Override
    public void create(FileSystemAbstraction fs, File fileName, long highId) {
    }

    @Override
    public IdGenerator get(IdType idType) {
        return this.idGenerators.get((Object)idType);
    }

    private static class BatchingIdGenerator
    implements IdGenerator {
        private final BatchingIdSequence idSequence;
        private final FileSystemAbstraction fs;
        private final File fileName;

        public BatchingIdGenerator(FileSystemAbstraction fs, File fileName, long highId) {
            this.fs = fs;
            this.fileName = fileName;
            this.idSequence = new BatchingIdSequence();
            this.idSequence.set(highId);
        }

        @Override
        public long nextId() {
            return this.idSequence.nextId();
        }

        @Override
        public IdRange nextIdBatch(int size) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setHighId(long id) {
            this.idSequence.set(id);
        }

        @Override
        public long getHighId() {
            return this.idSequence.peek();
        }

        @Override
        public void freeId(long id) {
        }

        @Override
        public void close() {
            this.fs.deleteFile(this.fileName);
            IdGeneratorImpl.createGenerator(this.fs, this.fileName, this.idSequence.peek());
        }

        @Override
        public long getNumberOfIdsInUse() {
            return this.idSequence.peek();
        }

        @Override
        public long getDefragCount() {
            return 0L;
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getHighestPossibleIdInUse() {
            return this.getHighId() - 1L;
        }
    }
}

